/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.asset;

import com.google.gson.JsonSyntaxException;
import goblinbob.mobends.core.asset.AssetDefinition;
import goblinbob.mobends.core.asset.AssetLocation;
import goblinbob.mobends.core.asset.AssetModels;
import goblinbob.mobends.core.asset.AssetTexture;
import goblinbob.mobends.core.asset.AssetType;
import goblinbob.mobends.core.asset.AssetsModule;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ProgressManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AssetReloadListener
implements IResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();

    public void func_110549_a(IResourceManager resourceManager) {
        AssetsModule.INSTANCE.updateAssets();
        AssetModels.INSTANCE.clearCache();
        Collection<AssetDefinition> assets = AssetsModule.INSTANCE.getAssets();
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Reloading Mo' Bends Assets", (int)assets.size(), (boolean)true);
        for (AssetDefinition asset : assets) {
            AssetLocation location = asset.getPath();
            bar.step(location.toString());
            AssetType assetType = location.getAssetType();
            if (assetType == AssetType.TEXTURE) {
                AssetTexture assetTexture = new AssetTexture(location);
                if (Minecraft.func_71410_x().func_110434_K().func_110579_a((ResourceLocation)location, (ITextureObject)assetTexture)) continue;
                LOGGER.error("Couldn't upload asset texture: {}", (Object)location.toString());
                continue;
            }
            if (assetType != AssetType.MODEL) continue;
            try {
                AssetModels.INSTANCE.register(location);
            }
            catch (JsonSyntaxException | IOException e) {
                LOGGER.error("Couldn't register asset model: {}", (Object)location.toString());
                e.printStackTrace();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }
}

