/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.bender;

import goblinbob.mobends.core.bender.BoneMetadata;
import goblinbob.mobends.core.bender.IPreviewer;
import goblinbob.mobends.core.bender.PreviewHelper;
import goblinbob.mobends.core.client.MutatedRenderer;
import goblinbob.mobends.core.data.EntityData;
import goblinbob.mobends.core.data.IEntityDataFactory;
import goblinbob.mobends.core.data.LivingEntityData;
import goblinbob.mobends.core.mutators.IMutatorFactory;
import goblinbob.mobends.core.mutators.Mutator;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class EntityBender<T extends EntityLivingBase> {
    protected final String key;
    protected final String unlocalizedName;
    private final MutatedRenderer<T> renderer;
    public final Class<T> entityClass;
    private final Map<RenderLivingBase<? extends T>, Mutator<LivingEntityData<T>, T, ?>> mutatorMap = new HashMap();
    private boolean animate;
    protected Map<String, BoneMetadata> boneMetadataMap;

    public EntityBender(String modId, @Nullable String key, String unlocalizedName, Class<T> entityClass, MutatedRenderer<T> renderer) {
        if (renderer == null) {
            throw new NullPointerException("The mutated renderer cannot be null.");
        }
        if (entityClass == null) {
            throw new NullPointerException("The entity class cannot be null.");
        }
        if (modId == null) {
            throw new NullPointerException("The Mod ID cannot be null.");
        }
        if (key == null) {
            ResourceLocation resourceLocation = EntityList.func_191306_a(entityClass);
            if (resourceLocation == null) {
                throw new RuntimeException("Unable to find a key for " + entityClass.getName());
            }
            key = resourceLocation.toString();
            unlocalizedName = "entity." + EntityList.func_191302_a((ResourceLocation)resourceLocation) + ".name";
        }
        this.key = modId + "-" + key;
        this.unlocalizedName = unlocalizedName;
        this.entityClass = entityClass;
        this.renderer = renderer;
    }

    public abstract String[] getAlterableParts();

    public abstract IEntityDataFactory<T> getDataFactory();

    public abstract IMutatorFactory<T> getMutatorFactory();

    public abstract IPreviewer<?> getPreviewer();

    public abstract LivingEntityData<?> getDataForPreview();

    public String getKey() {
        return this.key;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.unlocalizedName, (Object[])new Object[0]);
    }

    public boolean isAnimated() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public void beforeRender(EntityData<T> data, T entity, float partialTicks) {
        this.renderer.beforeRender(data, entity, partialTicks);
    }

    public void afterRender(T entity, float partialTicks) {
        this.renderer.afterRender(entity, partialTicks);
    }

    public boolean applyMutation(RenderLivingBase<? extends T> renderer, T entity, float partialTicks) {
        Mutator<LivingEntityData<T>, T, ?> mutator = this.mutatorMap.get(renderer);
        if (mutator == null) {
            mutator = this.getMutatorFactory().createMutator(this.getDataFactory());
            if (!mutator.mutate(renderer)) {
                return false;
            }
            this.mutatorMap.put(renderer, mutator);
        }
        mutator.updateModel(entity, renderer, partialTicks);
        LivingEntityData<T> data = mutator.getOrMakeData(entity);
        mutator.performAnimations(data, this.key, renderer, partialTicks);
        mutator.syncUpWithData(data);
        return true;
    }

    public void deapplyMutation(RenderLivingBase<? extends T> renderer, EntityLivingBase entity) {
        if (this.mutatorMap.containsKey(renderer)) {
            Mutator<LivingEntityData<T>, T, ?> mutator = this.mutatorMap.get(renderer);
            mutator.demutate(renderer);
            this.mutatorMap.remove(renderer);
        }
    }

    public void refreshMutation() {
        for (Map.Entry<RenderLivingBase<T>, Mutator<LivingEntityData<T>, T, ?>> entry : this.mutatorMap.entrySet()) {
            Mutator<LivingEntityData<T>, T, ?> mutator = entry.getValue();
            mutator.demutate(entry.getKey());
            mutator.mutate(entry.getKey());
            mutator.postRefresh();
        }
    }

    protected T createPreviewEntity() {
        try {
            EntityLiving entity = (EntityLiving)this.entityClass.getConstructor(World.class).newInstance(Minecraft.func_71410_x().field_71441_e);
            entity.field_70170_p = Minecraft.func_71410_x().field_71441_e;
            entity.func_70012_b(0.0, 0.0, 0.0, 0.0f, 0.0f);
            entity.func_180482_a(entity.field_70170_p.func_175649_E(entity.func_180425_c()), null);
            PreviewHelper.registerPreviewEntity((Entity)entity);
            return (T)entity;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Mutator<?, ?, ?> getMutator(RenderLivingBase<? extends EntityLivingBase> renderer) {
        return this.mutatorMap.get(renderer);
    }
}

