/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.gui;

import goblinbob.mobends.core.client.gui.CustomFont;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class CustomFontRenderer {
    protected CustomFont font;
    protected int characterSpacing = 1;

    public void setFont(CustomFont font) {
        this.font = font;
    }

    protected void drawSymbol(CustomFont.Symbol symbol, BufferBuilder vertexBuffer, int x, int y) {
        x += symbol.offsetX;
        y += symbol.offsetY;
        int width = symbol.width;
        int height = symbol.height;
        float textureX = (float)symbol.u / (float)this.font.atlasWidth;
        float textureY = (float)symbol.v / (float)this.font.atlasHeight;
        float textureWidth = (float)width / (float)this.font.atlasWidth;
        float textureHeight = (float)height / (float)this.font.atlasHeight;
        vertexBuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)textureX, (double)(textureY + textureHeight)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)(textureX + textureWidth), (double)(textureY + textureHeight)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y - height), 0.0).func_187315_a((double)(textureX + textureWidth), (double)textureY).func_181675_d();
        vertexBuffer.func_181662_b((double)x, (double)(y - height), 0.0).func_187315_a((double)textureX, (double)textureY).func_181675_d();
    }

    public int getTextWidth(String textToDraw) {
        int width = 0;
        for (int i = 0; i < textToDraw.length(); ++i) {
            CustomFont.Symbol symbol = this.font.getSymbol(textToDraw.charAt(i));
            width += symbol.width;
            if (i == textToDraw.length() - 1) continue;
            width += this.characterSpacing;
        }
        return width;
    }

    public void drawText(String textToDraw, int x, int y) {
        if (this.font == null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.font.resourceLocation);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int nextCharX = x;
        for (int i = 0; i < textToDraw.length(); ++i) {
            CustomFont.Symbol symbol = this.font.getSymbol(textToDraw.charAt(i));
            this.drawSymbol(symbol, vertexbuffer, nextCharX, y);
            nextCharX += symbol.width + this.characterSpacing;
        }
        tessellator.func_78381_a();
    }

    public void drawCenteredText(String textToDraw, int x, int y) {
        int width = this.getTextWidth(textToDraw);
        this.drawText(textToDraw, x - width / 2, y);
    }
}

