/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.gui.elements;

import goblinbob.mobends.core.client.gui.GuiBendsMenu;
import goblinbob.mobends.core.client.gui.IChangeListener;
import goblinbob.mobends.core.client.gui.IObservable;
import goblinbob.mobends.core.util.Draw;
import goblinbob.mobends.core.util.GUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.input.Mouse;

public class GuiDropDownList<T>
implements IObservable {
    public static final int HEIGHT = 16;
    public static final int LIST_HEIGHT = 90;
    public static final int ELEMENT_HEIGHT = 11;
    public static final int SCROLLBAR_WIDTH = 5;
    private final FontRenderer fontRenderer;
    protected final List<Entry<T>> entries;
    private int x;
    private int y;
    private int width;
    private int selectedIndex = 0;
    private int amountOfEntriesShown = 5;
    private boolean noValueAllowed = true;
    private boolean enabled = true;
    private boolean hovered = false;
    private boolean listHovered = false;
    private boolean scrollBarHovered = false;
    private boolean scrollBarGrabbed = false;
    private boolean dropped = false;
    private int hoveredEntryId = -1;
    private float scrollAmount;
    private int scrollBarY;
    private int scrollBarHeight;
    private int scrollBarGrabY;
    private List<IChangeListener> changeListeners = new LinkedList<IChangeListener>();

    @Override
    public List<IChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    public GuiDropDownList() {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.entries = new ArrayList<Entry<T>>();
        this.selectedIndex = 0;
        this.width = 94;
        this.scrollAmount = 0.0f;
    }

    public GuiDropDownList init() {
        this.entries.clear();
        this.selectedIndex = 0;
        this.scrollAmount = 0.0f;
        this.enabled = true;
        return this;
    }

    public GuiDropDownList setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public GuiDropDownList addEntry(String label, T value) {
        this.entries.add(new Entry<T>(label, value));
        this.updateDimensions();
        return this;
    }

    public GuiDropDownList setAmountOfEntriesShown(int amount) {
        this.amountOfEntriesShown = amount;
        this.updateDimensions();
        return this;
    }

    public void update(int mouseX, int mouseY) {
        if (!this.enabled) {
            return;
        }
        this.hovered = mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + 16;
        this.listHovered = false;
        this.hoveredEntryId = -1;
        this.scrollBarHovered = false;
        if (this.scrollBarGrabbed) {
            this.scroll((float)(mouseY - this.y - 16 - this.scrollBarY - this.scrollBarGrabY) / 11.0f);
        } else if (mouseX >= this.x && mouseX <= this.x + this.getWidth() && mouseY >= this.y + 16 && mouseY <= this.y + this.getVisualHeight()) {
            if (mouseX >= this.x + this.getWidth() - 5 - 1) {
                if (mouseY >= this.y + 16 + this.scrollBarY && mouseY <= this.y + 16 + this.scrollBarY + this.scrollBarHeight) {
                    this.scrollBarHovered = true;
                }
            } else {
                this.hoveredEntryId = this.getScrollInEntries() + (mouseY - this.y - 16) / 11;
            }
            this.listHovered = true;
        }
    }

    public boolean mouseClicked(int mouseX, int mouseY, int event) {
        if (!this.isEnabled()) {
            return false;
        }
        this.scrollBarGrabbed = false;
        if (this.hovered) {
            this.dropped = !this.dropped;
        } else if (this.dropped) {
            if (mouseX >= this.x + this.getWidth() - 5 - 1) {
                this.scrollBarGrabbed = true;
                this.scrollBarGrabY = this.scrollBarHovered ? mouseY - this.y - 16 - this.scrollBarY : this.scrollBarHeight / 2;
            } else {
                if (this.hoveredEntryId >= 0 && this.hoveredEntryId < this.entries.size() + (this.noValueAllowed ? 1 : 0) && this.hoveredEntryId != this.selectedIndex) {
                    this.selectedIndex = this.hoveredEntryId;
                    this.notifyChanged();
                }
                this.dropped = false;
            }
            return true;
        }
        return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.getVisualHeight();
    }

    public void mouseReleased(int mouseX, int mouseY, int event) {
        if (!this.isEnabled()) {
            return;
        }
        this.scrollBarGrabbed = false;
    }

    public boolean handleMouseInput() {
        if (!this.isEnabled()) {
            return false;
        }
        int mouseWheelRoll = -Mouse.getEventDWheel();
        if (this.dropped && this.listHovered) {
            if (mouseWheelRoll != 0) {
                mouseWheelRoll = mouseWheelRoll > 0 ? 1 : -1;
                this.scroll((float)mouseWheelRoll * 0.5f);
            }
            return true;
        }
        if (this.hovered) {
            if (mouseWheelRoll != 0) {
                mouseWheelRoll = mouseWheelRoll > 0 ? 1 : -1;
                this.selectedIndex = GUtil.clamp(this.selectedIndex + mouseWheelRoll, 0, this.entries.size() + (this.noValueAllowed ? 0 : -1));
                this.notifyChanged();
            }
            return true;
        }
        this.hoveredEntryId = -1;
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public GuiDropDownList enable() {
        this.enabled = true;
        return this;
    }

    public GuiDropDownList disable() {
        this.enabled = false;
        return this;
    }

    public void display() {
        if (!this.isEnabled()) {
            return;
        }
        Draw.rectangle(this.x, this.y, this.width, 16, -6250336);
        Draw.rectangle(this.x + 1, this.y + 1, this.width - 2, 14, this.hovered || this.dropped ? -14540254 : -16777216);
        boolean noValue = this.noValueAllowed && this.selectedIndex == 0;
        String text = noValue ? "None" : this.fontRenderer.func_78269_a(this.getSelectedEntry().getLabel(), this.getWidth() - 20);
        this.fontRenderer.func_175063_a(text, (float)(this.x + 5), (float)(this.y + 4), noValue ? 0x999999 : 0xE2E2E2);
        Draw.rectangleHorizontalGradient((float)(this.x + this.width - 40), (float)(this.y + 1), 27.0f, 14.0f, 0, this.hovered || this.dropped ? -14540254 : -16777216);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBendsMenu.ICONS_TEXTURE);
        Draw.texturedModalRect(this.x + this.width - 12, this.y + 3, 94, 24 + (this.hovered || this.dropped ? 10 : 0), 10, 10);
        if (this.dropped) {
            int elements = this.getNumberOfElements();
            Draw.rectangle(this.x, this.y + 16, this.width, elements * 11 + 3, -7829368);
            Draw.rectangle(this.x + 1, this.y + 16, this.width - 2, elements * 11 + 2, -16777216);
            for (int i = 0; i < elements; ++i) {
                int entryID = this.getScrollInEntries() + i - (this.noValueAllowed ? 1 : 0);
                boolean bl = noValue = this.noValueAllowed && i == 0;
                if (this.hoveredEntryId == this.getScrollInEntries() + i) {
                    Draw.rectangle(this.x + 1, this.y + 16 + i * 11, this.width - 2, 11, -14535873);
                } else if (this.selectedIndex == this.getScrollInEntries() + i) {
                    Draw.rectangle(this.x + 1, this.y + 16 + i * 11, this.width - 2, 11, -15395547);
                }
                String name = noValue ? "None" : this.fontRenderer.func_78269_a(this.entries.get(entryID).getLabel(), this.getWidth());
                this.fontRenderer.func_175063_a(name, (float)(this.x + 3), (float)(this.y + 16 + i * 11 + 2), noValue ? 0x999999 : 0xE2E2E2);
            }
            if (this.shouldShowScrollBar()) {
                Draw.rectangle(this.x + this.width - 5 - 1, this.y + 16, 5, elements * 11 + 2, -14540254);
                Draw.rectangle(this.x + this.width - 5 - 1, this.y + 16 + this.scrollBarY, 5, this.scrollBarHeight, this.scrollBarHovered ? -10066330 : -12303292);
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getVisualHeight() {
        return this.dropped ? 16 + this.getNumberOfElements() * 11 + 3 : 16;
    }

    public Entry<T> getSelectedEntry() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.entries.size() + (this.noValueAllowed ? 1 : 0)) {
            return null;
        }
        if (this.noValueAllowed && this.selectedIndex == 0) {
            return null;
        }
        return this.entries.get(this.selectedIndex - (this.noValueAllowed ? 1 : 0));
    }

    public int getNumberOfElements() {
        int elements = this.entries.size() + (this.noValueAllowed ? 1 : 0);
        if (this.amountOfEntriesShown > 0) {
            elements = Math.min(elements, this.amountOfEntriesShown);
        }
        return elements;
    }

    public GuiDropDownList<T> allowNoValue() {
        this.noValueAllowed = true;
        return this;
    }

    public GuiDropDownList<T> forbidNoValue() {
        this.noValueAllowed = false;
        return this;
    }

    public boolean shouldShowScrollBar() {
        return this.entries.size() > this.getNumberOfElements();
    }

    public float getScrollPercentage() {
        return this.scrollAmount / (float)(this.entries.size() - this.getNumberOfElements());
    }

    public int getScrollInEntries() {
        return (int)Math.max(0.0f, this.scrollAmount);
    }

    public void scroll(float amount) {
        this.scrollAmount = GUtil.clamp(this.scrollAmount + amount, 0.0f, (float)(this.entries.size() - this.getNumberOfElements()));
        this.scrollBarY = (int)(this.getScrollPercentage() * (float)(this.getNumberOfElements() * 11 + 2 - this.scrollBarHeight));
    }

    public void selectValue(T value) {
        int previouslySelected = this.selectedIndex;
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!((Entry)this.entries.get(i)).value.equals(value)) continue;
            this.selectedIndex = i + (this.noValueAllowed ? 1 : 0);
            if (previouslySelected != this.selectedIndex) {
                this.notifyChanged();
            }
            return;
        }
        this.selectedIndex = 0;
        if (previouslySelected != this.selectedIndex) {
            this.notifyChanged();
        }
    }

    public T getSelectedValue() {
        if (this.getSelectedEntry() == null) {
            return null;
        }
        return this.getSelectedEntry().getValue();
    }

    public void updateDimensions() {
        this.scrollBarHeight = (int)((float)this.getNumberOfElements() / (float)this.entries.size() * (float)(this.getNumberOfElements() * 11 + 2));
        this.scrollBarY = (int)(this.getScrollPercentage() * (float)(this.getNumberOfElements() * 11 + 2 - this.scrollBarHeight));
    }

    public static class Entry<T> {
        private String label;
        private T value;

        public Entry(String label, T value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public T getValue() {
            return this.value;
        }
    }
}

