/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.gui.elements;

import goblinbob.mobends.core.client.event.DataUpdateHandler;
import goblinbob.mobends.core.client.gui.CustomFont;
import goblinbob.mobends.core.client.gui.CustomFontRenderer;
import goblinbob.mobends.core.util.Color;
import goblinbob.mobends.core.util.Draw;
import goblinbob.mobends.core.util.GuiHelper;
import goblinbob.mobends.core.util.IColorRead;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class GuiSectionButton {
    public static final ResourceLocation BUTTONS_TEXTURE = new ResourceLocation("mobends", "textures/gui/buttons.png");
    public static final float HOVER_ICON_ANIMATION_DURATION = 2.0f;
    public static final float HOVER_BG_ANIMATION_DURATION = 2.0f;
    protected final Minecraft mc = Minecraft.func_71410_x();
    private String label;
    private int x;
    private int y;
    private int width;
    private int height;
    private int bgTextureU;
    private int bgTextureV;
    private Color neutralColor;
    private Color bgColor;
    private SectionIcon leftIcon = null;
    private SectionIcon rightIcon = null;
    private CustomFontRenderer fontRenderer;
    private boolean hover;
    private boolean pressed;
    private float ticksAfterHovered = 0.0f;

    public GuiSectionButton(int x, int y, String label, IColorRead bgColor) {
        this.label = label;
        this.x = x;
        this.y = y;
        this.width = 318;
        this.height = 43;
        this.bgTextureU = 0;
        this.bgTextureV = 0;
        this.neutralColor = new Color(-8947849);
        this.bgColor = new Color(bgColor);
        this.hover = false;
        this.pressed = false;
        this.fontRenderer = new CustomFontRenderer();
        this.fontRenderer.setFont(CustomFont.BOLD);
    }

    public GuiSectionButton(String label, IColorRead bgColor) {
        this(0, 0, label, bgColor);
    }

    public GuiSectionButton(String label, int bgColor) {
        this(0, 0, label, Color.fromHex(bgColor));
    }

    public GuiSectionButton setLeftIcon(int u, int v, int width, int height) {
        this.leftIcon = new SectionIcon(u, v, width, height);
        return this;
    }

    public GuiSectionButton setRightIcon(int u, int v, int width, int height) {
        this.rightIcon = new SectionIcon(u, v, width, height);
        return this;
    }

    public void initGui(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void update(int mouseX, int mouseY) {
        boolean nowHover;
        boolean bl = nowHover = mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        if (nowHover && !this.hover) {
            this.onHover();
        }
        this.hover = nowHover;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int event) {
        if (this.hover) {
            GuiHelper.playButtonSound(this.mc.func_147118_V());
            this.pressed = true;
        }
        return this.pressed;
    }

    public void mouseReleased(int mouseX, int mouseY, int event) {
        this.pressed = false;
    }

    public void onHover() {
        this.ticksAfterHovered = 0.0f;
    }

    public void display() {
        this.ticksAfterHovered += DataUpdateHandler.ticksPerFrame;
        if (this.hover) {
            GlStateManager.func_179131_c((float)this.bgColor.r, (float)this.bgColor.g, (float)this.bgColor.b, (float)this.bgColor.a);
        } else {
            GlStateManager.func_179131_c((float)this.neutralColor.r, (float)this.neutralColor.g, (float)this.neutralColor.b, (float)this.neutralColor.a);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BUTTONS_TEXTURE);
        int tX = this.bgTextureU;
        int tY = this.bgTextureV;
        float uScale = 0.001953125f;
        float vScale = 0.0078125f;
        if (this.hover) {
            GlStateManager.func_179131_c((float)this.bgColor.r, (float)this.bgColor.g, (float)this.bgColor.b, (float)this.bgColor.a);
        } else {
            GlStateManager.func_179131_c((float)this.neutralColor.r, (float)this.neutralColor.g, (float)this.neutralColor.b, (float)this.neutralColor.a);
        }
        GlStateManager.func_179090_x();
        Draw.rectangle(this.x, this.y, this.width, this.height);
        GlStateManager.func_179098_w();
        float bgt = 1.0f;
        if (this.hover) {
            if (this.ticksAfterHovered < 2.0f) {
                bgt = 1.0f - this.ticksAfterHovered / 2.0f;
                bgt = bgt * bgt * bgt;
            } else {
                bgt = 0.0f;
            }
        }
        int mountainOffsetY = (int)(bgt * 10.0f);
        Draw.texturedRectangle(this.x, this.y + mountainOffsetY, this.width, this.height - 2 - mountainOffsetY, (float)tX * uScale, (float)tY * vScale, (float)(tX + this.width) * uScale, (float)(tY + this.height - 2 - mountainOffsetY) * vScale);
        Draw.texturedRectangle(this.x, this.y + this.height - 2, this.width, 2, (float)tX * uScale, (float)(tY + this.height - 2) * vScale, (float)(tX + this.width) * uScale, (float)(tY + 2) * vScale);
        if (this.hover) {
            float scale = 1.0f;
            if (this.ticksAfterHovered < 2.0f) {
                float PI = (float)Math.PI;
                float t = this.ticksAfterHovered / 2.0f;
                scale = 1.0f - MathHelper.func_76134_b((float)(t * PI * 1.5f));
                scale = MathHelper.func_76129_c((float)scale);
            }
            int iconSpacing = 30;
            if (this.leftIcon != null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(this.x + iconSpacing), (float)((float)this.y + (float)this.height / 2.0f), (float)0.0f);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                this.leftIcon.draw(uScale, vScale);
                GlStateManager.func_179121_F();
            }
            if (this.rightIcon != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(this.x + this.width - iconSpacing), (float)((float)this.y + (float)this.height / 2.0f), (float)0.0f);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                this.rightIcon.draw(uScale, vScale);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.fontRenderer.drawCenteredText(this.label, this.x + this.width / 2, this.y + this.height / 2 + 6);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setPosition(int i, int j) {
        this.x = i;
        this.y = j;
    }

    private static class SectionIcon {
        private int texU;
        private int texV;
        private int texWidth;
        private int texHeight;

        public SectionIcon(int u, int v, int width, int height) {
            this.texU = u;
            this.texV = v;
            this.texWidth = width;
            this.texHeight = height;
        }

        public void draw(float uScale, float vScale) {
            Draw.texturedRectangle(-this.texWidth / 2, -this.texHeight / 2, this.texWidth, this.texHeight, (float)this.texU * uScale, (float)this.texV * vScale, (float)this.texWidth * uScale, (float)this.texHeight * vScale);
        }
    }
}

