/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.gui.elements;

import goblinbob.mobends.core.client.gui.elements.IGuiElement;
import goblinbob.mobends.core.client.gui.elements.IGuiPositioned;
import java.util.Iterator;
import java.util.LinkedList;

public interface IGuiElementsContainer
extends IGuiPositioned {
    public LinkedList<IGuiElement> getElements();

    default public void addElement(IGuiElement element) {
        this.getElements().add(element);
        element.initGui();
    }

    default public void drawChildren(float partialTicks) {
        for (IGuiElement element : this.getElements()) {
            element.draw(partialTicks);
        }
    }

    default public void updateChildren(int mouseX, int mouseY) {
        for (IGuiElement element : this.getElements()) {
            element.update(mouseX - this.getX(), mouseY - this.getY());
        }
    }

    default public boolean handleMouseClickedChildren(int mouseX, int mouseY, int button) {
        Iterator<IGuiElement> it = this.getElements().descendingIterator();
        while (it.hasNext()) {
            if (!it.next().handleMouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    default public boolean handleMouseReleasedChildren(int mouseX, int mouseY, int button) {
        Iterator<IGuiElement> it = this.getElements().descendingIterator();
        while (it.hasNext()) {
            if (!it.next().handleMouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }
}

