/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.model;

import goblinbob.mobends.core.client.model.BoxFactory;
import goblinbob.mobends.core.client.model.IModelPart;
import goblinbob.mobends.core.client.model.MutatedBox;
import goblinbob.mobends.core.math.SmoothOrientation;
import goblinbob.mobends.core.math.TransformUtils;
import goblinbob.mobends.core.math.matrix.IMat4x4d;
import goblinbob.mobends.core.math.physics.AABBoxGroup;
import goblinbob.mobends.core.math.physics.IAABBox;
import goblinbob.mobends.core.math.physics.ICollider;
import goblinbob.mobends.core.math.vector.IVec3f;
import goblinbob.mobends.core.math.vector.Vec3f;
import goblinbob.mobends.core.util.GlHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelPart
extends ModelRenderer
implements IModelPart {
    public Vec3f position = new Vec3f();
    public Vec3f scale = new Vec3f(1.0f, 1.0f, 1.0f);
    public Vec3f offset = new Vec3f();
    public SmoothOrientation rotation = new SmoothOrientation();
    public float offsetScale = 1.0f;
    public Vec3f globalOffset = new Vec3f();
    protected List<MutatedBox> mutatedBoxes = new ArrayList<MutatedBox>();
    protected IModelPart parent;
    protected ICollider collider;

    public ModelPart(ModelBase model, boolean register, int texOffsetX, int texOffsetY) {
        super(model, texOffsetX, texOffsetY);
        if (!register) {
            model.field_78092_r.remove(model.field_78092_r.size() - 1);
        }
    }

    public ModelPart(ModelBase model, boolean register) {
        this(model, register, 0, 0);
    }

    public ModelPart(ModelBase model, int texOffsetX, int texOffsetY) {
        this(model, true, texOffsetX, texOffsetY);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78785_a(float scale) {
        this.renderPart(scale);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78791_b(float scale) {
        this.renderPart(scale);
    }

    @Override
    public void renderPart(float scale) {
        if (!this.isShowing()) {
            return;
        }
        if (!this.field_78812_q) {
            this.func_78788_d(scale);
        }
        GlStateManager.func_179094_E();
        this.applyCharacterTransform(scale);
        GlStateManager.func_179148_o((int)this.field_78811_r);
        if (this.field_78805_m != null) {
            for (ModelRenderer childModel : this.field_78805_m) {
                childModel.func_78785_a(scale);
            }
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderJustPart(float scale) {
        if (!this.isShowing()) {
            return;
        }
        if (!this.field_78812_q) {
            this.func_78788_d(scale);
        }
        GlStateManager.func_179094_E();
        this.applyLocalTransform(scale);
        GlStateManager.func_179148_o((int)this.field_78811_r);
        if (this.field_78805_m != null) {
            for (ModelRenderer childModel : this.field_78805_m) {
                childModel.func_78785_a(scale);
            }
        }
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78794_c(float scale) {
        this.applyCharacterTransform(scale);
        this.applyPostTransform(scale);
    }

    @Override
    public void applyPreTransform(float scale) {
        if (this.globalOffset.x != 0.0f || this.globalOffset.y != 0.0f || this.globalOffset.z != 0.0f) {
            GlStateManager.func_179109_b((float)(this.globalOffset.x * scale), (float)(this.globalOffset.y * scale), (float)(this.globalOffset.z * scale));
        }
    }

    @Override
    public void applyPreTransform(float scale, IMat4x4d dest) {
        if (this.globalOffset.x != 0.0f || this.globalOffset.y != 0.0f || this.globalOffset.z != 0.0f) {
            TransformUtils.translate(dest, this.globalOffset.x * scale, this.globalOffset.y * scale, this.globalOffset.z * scale);
        }
    }

    @Override
    public void applyLocalTransform(float scale) {
        if (this.position.x != 0.0f || this.position.y != 0.0f || this.position.z != 0.0f) {
            GlStateManager.func_179109_b((float)(this.position.x * scale * this.offsetScale), (float)(this.position.y * scale * this.offsetScale), (float)(this.position.z * scale * this.offsetScale));
        }
        if (this.offset.x != 0.0f || this.offset.y != 0.0f || this.offset.z != 0.0f) {
            GlStateManager.func_179109_b((float)(this.offset.x * scale * this.offsetScale), (float)(this.offset.y * scale * this.offsetScale), (float)(this.offset.z * scale * this.offsetScale));
        }
        GlHelper.rotate(this.rotation.getSmooth());
        if (this.scale.x != 0.0f || this.scale.y != 0.0f || this.scale.z != 0.0f) {
            GlStateManager.func_179152_a((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
        }
    }

    @Override
    public void applyLocalTransform(float scale, IMat4x4d matrix) {
        if (this.position.x != 0.0f || this.position.y != 0.0f || this.position.z != 0.0f) {
            TransformUtils.translate(matrix, this.position.x * scale * this.offsetScale, this.position.y * scale * this.offsetScale, this.position.z * scale * this.offsetScale);
        }
        if (this.offset.x != 0.0f || this.offset.y != 0.0f || this.offset.z != 0.0f) {
            TransformUtils.translate(matrix, this.offset.x * scale * this.offsetScale, this.offset.y * scale * this.offsetScale, this.offset.z * scale * this.offsetScale);
        }
        TransformUtils.rotate(matrix, this.rotation.getSmooth());
        if (this.scale.x != 0.0f || this.scale.y != 0.0f || this.scale.z != 0.0f) {
            TransformUtils.scale(matrix, this.scale.x, this.scale.y, this.scale.z, matrix);
        }
    }

    @Override
    public void applyPostTransform(float scale) {
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_78788_d(float scale) {
        this.field_78811_r = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)this.field_78811_r, (int)4864);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        for (ModelBox modelBox : this.field_78804_l) {
            modelBox.func_178780_a(bufferbuilder, scale);
        }
        GlStateManager.func_187415_K();
        this.field_78812_q = true;
    }

    @Override
    public void update(float ticksPerFrame) {
        this.rotation.update(ticksPerFrame);
    }

    public void func_78793_a(float x, float y, float z) {
    }

    public ModelPart setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
        return this;
    }

    public ModelPart setOffset(float x, float y, float z) {
        this.field_82906_o = x;
        this.field_82908_p = y;
        this.field_82907_q = z;
        return this;
    }

    public ModelPart setScale(float x, float y, float z) {
        this.scale.x = x;
        this.scale.y = y;
        this.scale.z = z;
        return this;
    }

    public ModelPart resetScale() {
        this.scale.set(0.0f, 0.0f, 0.0f);
        return this;
    }

    public BoxFactory developBox(float x, float y, float z, int dx, int dy, int dz, float scaleFactor) {
        return new BoxFactory(x, y, z, dx, dy, dz, scaleFactor).setTarget(this);
    }

    public ModelPart addVanillaBox(ModelBox box) {
        this.field_78804_l.add(box);
        this.field_78812_q = false;
        return this;
    }

    public ModelPart addBox(MutatedBox box) {
        this.mutatedBoxes.add(box);
        this.field_78804_l.add(box);
        this.field_78812_q = false;
        return this;
    }

    public ModelPart addModelBox(float x, float y, float z, int width, int height, int length, float scaleFactor) {
        return this.addBox(new MutatedBox(this, this.field_78803_o, this.field_78813_p, x, y, z, width, height, length, scaleFactor));
    }

    public ModelPart addBox(String partName, float offX, float offY, float offZ, int width, int height, int depth) {
        partName = this.field_78802_n + "." + partName;
        TextureOffset textureoffset = this.field_78810_s.func_78084_a(partName);
        this.func_78784_a(textureoffset.field_78783_a, textureoffset.field_78782_b);
        return this.addBox((MutatedBox)new MutatedBox(this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, 0.0f).func_78244_a(partName));
    }

    public ModelPart addBox(float offX, float offY, float offZ, int width, int height, int depth) {
        return this.addBox(new MutatedBox(this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, 0.0f));
    }

    public ModelPart addBox(float offX, float offY, float offZ, int width, int height, int depth, boolean mirrored) {
        return this.addBox(new MutatedBox(this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, 0.0f, mirrored));
    }

    public void func_78790_a(float x, float y, float z, int width, int height, int length, float scaleFactor) {
        this.addModelBox(x, y, z, width, height, length, scaleFactor);
    }

    public MutatedBox getBox() {
        return this.getBox(0);
    }

    public MutatedBox getBox(int idx) {
        return (MutatedBox)((Object)this.field_78804_l.get(idx));
    }

    @Override
    public Vec3f getPosition() {
        return this.position;
    }

    @Override
    public Vec3f getScale() {
        return this.scale;
    }

    @Override
    public Vec3f getOffset() {
        return this.offset;
    }

    @Override
    public SmoothOrientation getRotation() {
        return this.rotation;
    }

    @Override
    public float getOffsetScale() {
        return this.offsetScale;
    }

    @Override
    public IVec3f getGlobalOffset() {
        return this.globalOffset;
    }

    @Override
    public IModelPart getParent() {
        return this.parent;
    }

    @Override
    public boolean isShowing() {
        return this.field_78806_j && !this.field_78807_k;
    }

    protected void updateBounds() {
        if (this.mutatedBoxes.size() == 1) {
            this.collider = this.mutatedBoxes.get(0).createAABB();
        } else {
            IAABBox[] bounds = new IAABBox[this.mutatedBoxes.size()];
            for (int i = 0; i < bounds.length; ++i) {
                bounds[i] = this.mutatedBoxes.get(i).createAABB();
            }
            this.collider = new AABBoxGroup(bounds);
        }
    }

    public ModelPart setMirror(boolean mirror) {
        this.field_78809_i = mirror;
        return this;
    }

    public void finish() {
        this.rotation.finish();
    }

    @Override
    public void syncUp(IModelPart part) {
        if (part == null) {
            return;
        }
        this.position.set(part.getPosition());
        this.offset.set(part.getOffset());
        this.rotation.set(part.getRotation());
        this.scale.set(part.getScale());
        this.offsetScale = part.getOffsetScale();
        this.globalOffset.set(part.getGlobalOffset());
    }

    @Override
    public void setVisible(boolean showModel) {
        this.field_78806_j = showModel;
    }

    public ModelPart setParent(IModelPart parent) {
        this.parent = parent;
        return this;
    }

    public int getTextureOffsetX() {
        return this.field_78803_o;
    }

    public int getTextureOffsetY() {
        return this.field_78813_p;
    }
}

