/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.animation.bit.spider;

import goblinbob.mobends.core.client.event.DataUpdateHandler;
import goblinbob.mobends.standard.animation.bit.spider.SpiderAnimationBitBase;
import goblinbob.mobends.standard.data.SpiderData;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.util.math.MathHelper;

public class SpiderCrawlAnimationBit
extends SpiderAnimationBitBase {
    protected static final String[] ACTIONS = new String[]{"crawl"};

    @Override
    public String[] getActions(SpiderData entityData) {
        return ACTIONS;
    }

    @Override
    public void perform(SpiderData data) {
        float pt = DataUpdateHandler.partialTicks;
        EntitySpider spider = (EntitySpider)data.getEntity();
        float headYaw = ((Float)data.headYaw.get()).floatValue();
        float headPitch = ((Float)data.headPitch.get()).floatValue();
        float limbSwing = data.getInterpolatedCrawlProgress() * 5.0f;
        float groundLevel = MathHelper.func_76126_a((float)(limbSwing * 0.6f)) * 1.2f;
        if (this.startTransition < 1.0f) {
            this.startTransition += DataUpdateHandler.ticksPerFrame * 0.1f;
        }
        data.spiderHead.rotation.orientInstantX(headPitch);
        data.spiderHead.rotation.rotateY(headYaw).finish();
        this.animateMovingLimb(data, groundLevel, limbSwing + 0.0f, 0, 20.0f, 10.0f, -80.0f, -50.0f);
        this.animateMovingLimb(data, groundLevel, limbSwing + 0.3f, 1, 20.0f, 10.0f, -80.0f, -50.0f);
        this.animateMovingLimb(data, groundLevel, limbSwing + 0.3f, 2, 15.0f, 15.0f, -30.0f, 10.0f);
        this.animateMovingLimb(data, groundLevel, limbSwing + 0.0f, 3, 15.0f, 15.0f, -30.0f, 10.0f);
        this.animateMovingLimb(data, groundLevel, limbSwing + 0.4f, 4, 7.0f, 15.0f, 20.0f, 50.0f);
        this.animateMovingLimb(data, groundLevel, limbSwing + 0.7f, 5, 7.0f, 15.0f, 20.0f, 50.0f);
        this.animateMovingLimb(data, groundLevel, limbSwing + 0.7f, 6, 10.0f, 20.0f, 60.0f, 80.0f);
        this.animateMovingLimb(data, groundLevel, limbSwing + 0.4f, 7, 10.0f, 20.0f, 60.0f, 80.0f);
        float climbingRotation = data.getCrawlingRotation();
        float yaw = spider.field_70126_B + (spider.field_70177_z - spider.field_70126_B) * pt;
        float renderRotationY = MathHelper.func_76142_g((float)(yaw - climbingRotation));
        data.renderRotation.orientX(-90.0f);
        data.renderRotation.setSmoothness(0.6f).rotateY(renderRotationY);
        data.localOffset.slideTo(0.0f, -10.0f, 0.0f, 0.5f);
        data.centerRotation.orientZero();
    }
}

