/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.animation.controller;

import goblinbob.mobends.core.animation.bit.AnimationBit;
import goblinbob.mobends.core.animation.controller.IAnimationController;
import goblinbob.mobends.core.animation.layer.HardAnimationLayer;
import goblinbob.mobends.standard.animation.bit.biped.JumpAnimationBit;
import goblinbob.mobends.standard.animation.bit.biped.StandAnimationBit;
import goblinbob.mobends.standard.animation.bit.biped.WalkAnimationBit;
import goblinbob.mobends.standard.animation.bit.zombie_base.ZombieLeanAnimationBit;
import goblinbob.mobends.standard.animation.bit.zombie_base.ZombieStumblingAnimationBit;
import goblinbob.mobends.standard.data.ZombieData;
import java.util.ArrayList;
import java.util.Collection;

public class ZombieController
implements IAnimationController<ZombieData> {
    protected HardAnimationLayer<ZombieData> layerBase = new HardAnimationLayer();
    protected HardAnimationLayer<ZombieData> layerSet = new HardAnimationLayer();
    protected AnimationBit<ZombieData> bitStand = new StandAnimationBit<ZombieData>();
    protected AnimationBit<ZombieData> bitWalk = new WalkAnimationBit<ZombieData>();
    protected AnimationBit<ZombieData> bitJump = new JumpAnimationBit<ZombieData>();
    protected AnimationBit<ZombieData>[] bitAnimationSet = new AnimationBit[]{new ZombieLeanAnimationBit(), new ZombieStumblingAnimationBit()};

    @Override
    public Collection<String> perform(ZombieData zombieData) {
        if (!zombieData.isOnGround() || zombieData.getTicksAfterTouchdown() < 1.0f) {
            this.layerBase.playOrContinueBit(this.bitJump, zombieData);
        } else if (zombieData.isStillHorizontally()) {
            this.layerBase.playOrContinueBit(this.bitStand, zombieData);
        } else {
            this.layerBase.playOrContinueBit(this.bitWalk, zombieData);
        }
        this.layerSet.playOrContinueBit(this.bitAnimationSet[zombieData.getAnimationSet()], zombieData);
        ArrayList<String> actions = new ArrayList<String>();
        this.layerBase.perform(zombieData, actions);
        this.layerSet.perform(zombieData, actions);
        return actions;
    }
}

