/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.armorunder.recipes;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.armorunder.recipes.ArmorRecipes;
import org.jwaresoftware.mcmods.lib.Armory;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public abstract class LinedArmorRecipeSkeleton
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    static final String NBT_MOD = Armory.XLining.NBT_VALUE_TAGNAME;
    protected final IRecipe _impl;

    LinedArmorRecipeSkeleton(IRecipe template) {
        this._impl = template;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height == 2;
    }

    public ItemStack func_77571_b() {
        return ItemStacks.NULLSTACK();
    }

    protected abstract boolean isLining(Item var1);

    protected abstract boolean canAddLining(ItemStack var1);

    protected abstract Armory.XLining.Def getXLining(ItemStack var1);

    protected boolean isEnabled() {
        return ArmorRecipes.ENABLED;
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        boolean match;
        boolean bl = match = this.isEnabled() && this._impl.func_77569_a(grid, world);
        if (match) {
            boolean found_armor = false;
            boolean found_lining = false;
            for (int i = 0; i < grid.func_70302_i_(); ++i) {
                ItemStack next = grid.func_70301_a(i);
                if (ItemStacks.isEmpty((ItemStack)next)) continue;
                if (this.isLining(next.func_77973_b())) {
                    if (found_lining) {
                        return false;
                    }
                    found_lining = true;
                    continue;
                }
                if (!Armory.isLiningAllowed((ItemStack)next)) continue;
                if (found_armor) {
                    return false;
                }
                found_armor = true;
            }
            if (!found_armor || !found_lining) {
                match = false;
            }
        }
        return match;
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack out = ItemStacks.NULLSTACK();
        if (this.isEnabled()) {
            ItemStack lining = null;
            ItemStack armorpiece = null;
            for (int i = 0; i < grid.func_70302_i_(); ++i) {
                ItemStack next = grid.func_70301_a(i);
                if (ItemStacks.isEmpty((ItemStack)next)) continue;
                if (this.isLining(next.func_77973_b())) {
                    lining = next;
                    continue;
                }
                if (!Armory.isLiningAllowed((ItemStack)next)) continue;
                armorpiece = next;
            }
            if (lining != null && armorpiece != null && this.canAddLining(armorpiece)) {
                out = ItemStacks.copyItemStackSingle(armorpiece);
                Armory.XLining.Def defn = this.getXLining(lining);
                out = Armory.setXLining((ItemStack)out, (Armory.XLining.Def)defn);
            }
        }
        return out;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
        return SharedGlue.emptyNonNullItemStackList((int)grid.func_70302_i_());
    }
}

