/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft;

import com.github.fnar.minecraft.PositionInfo1_12;
import com.github.fnar.minecraft.block.BlockMapper1_12;
import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.Material;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.decorative.Plant;
import com.github.fnar.minecraft.block.decorative.Skull;
import com.github.fnar.minecraft.block.normal.StairsBlock;
import com.github.fnar.minecraft.item.ItemMapper1_12;
import com.github.fnar.minecraft.item.RldItemStack;
import com.google.common.collect.Lists;
import greymerk.roguelike.TreasureChestEditor;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.util.DyeColor;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.MetaBlock1_2;
import greymerk.roguelike.worldgen.PositionInfo;
import greymerk.roguelike.worldgen.VanillaStructure;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import org.apache.logging.log4j.LogManager;

public class WorldEditor1_12
implements WorldEditor {
    private static final List<net.minecraft.block.material.Material> invalid = Lists.newArrayList((Object[])new net.minecraft.block.material.Material[]{net.minecraft.block.material.Material.field_151579_a, net.minecraft.block.material.Material.field_151575_d, net.minecraft.block.material.Material.field_151586_h, net.minecraft.block.material.Material.field_151570_A, net.minecraft.block.material.Material.field_151597_y, net.minecraft.block.material.Material.field_151577_b, net.minecraft.block.material.Material.field_151572_C, net.minecraft.block.material.Material.field_151584_j, net.minecraft.block.material.Material.field_151585_k});
    private final World world;
    private final Map<Block, Integer> stats = new HashMap<Block, Integer>();
    private final TreasureChestEditor treasureChestEditor;
    private final Random random;

    public WorldEditor1_12(World world) {
        this.world = world;
        this.random = new Random(Objects.hash(this.getSeed()));
        this.treasureChestEditor = new TreasureChestEditor(this, this.random);
    }

    @Override
    public void setSkull(WorldEditor editor, Coord cursor, Direction dir, Skull type) {
        SingleBlockBrush skullBlock = BlockType.SKULL.getBrush();
        skullBlock.setFacing(Direction.UP);
        if (!skullBlock.stroke(editor, cursor)) {
            return;
        }
        TileEntity tileEntity = editor.getTileEntity(cursor);
        if (tileEntity == null) {
            return;
        }
        if (!(tileEntity instanceof TileEntitySkull)) {
            return;
        }
        TileEntitySkull tileEntitySkull = (TileEntitySkull)tileEntity;
        WorldEditor1_12.setSkullType(tileEntitySkull, type);
        WorldEditor1_12.setSkullRotation(editor.getRandom(cursor), tileEntitySkull, dir);
    }

    public static void setSkullType(TileEntitySkull skull, Skull type) {
        skull.func_152107_a(WorldEditor1_12.getSkullId(type));
    }

    public static void setSkullRotation(Random rand, TileEntitySkull skull, Direction dir) {
        int directionValue = WorldEditor1_12.getDirectionValue(dir);
        directionValue += -1 + rand.nextInt(3);
        skull.func_145903_a(directionValue %= 16);
    }

    public static int getSkullId(Skull type) {
        switch (type) {
            default: {
                return 0;
            }
            case WITHER: {
                return 1;
            }
            case ZOMBIE: {
                return 2;
            }
            case STEVE: {
                return 3;
            }
            case CREEPER: 
        }
        return 4;
    }

    public static int getDirectionValue(Direction dir) {
        switch (dir) {
            default: {
                return 0;
            }
            case EAST: {
                return 4;
            }
            case SOUTH: {
                return 8;
            }
            case WEST: 
        }
        return 12;
    }

    @Override
    public boolean isSolidBlock(Coord coord) {
        return this.getBlockStateAt(coord).func_185904_a().func_76220_a();
    }

    private IBlockState getBlockStateAt(Coord coord) {
        return this.world.func_180495_p(this.getBlockPos(coord));
    }

    @Override
    public boolean isOpaqueBlock(Coord coord) {
        return this.getBlockStateAt(coord).func_185904_a().func_76218_k();
    }

    @Override
    public boolean isOpaqueCubeBlock(Coord coord) {
        return this.getBlockStateAt(coord).func_185914_p();
    }

    @Override
    public boolean isBlockOfTypeAt(BlockType blockType, Coord coord) {
        return BlockMapper1_12.map(blockType).getBlock() == this.getBlockStateAt(coord).func_177230_c();
    }

    @Override
    public boolean isMaterialAt(Material material, Coord coord) {
        return false;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    private BlockPos getBlockPos(Coord pos) {
        return new BlockPos(pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public boolean setBlock(Coord coord, SingleBlockBrush singleBlockBrush, boolean fillAir, boolean replaceSolid) {
        if (this.isBlockOfTypeAt(BlockType.CHEST, coord) || this.isBlockOfTypeAt(BlockType.TRAPPED_CHEST, coord) || this.isBlockOfTypeAt(BlockType.MOB_SPAWNER, coord)) {
            return false;
        }
        boolean isAir = this.isBlockOfTypeAt(BlockType.AIR, coord);
        if (!fillAir && isAir) {
            return false;
        }
        if (!replaceSolid && !isAir) {
            return false;
        }
        return this.setBlock(MetaBlock1_2.getMetaBlock(singleBlockBrush), coord);
    }

    private boolean setBlock(MetaBlock1_2 metaBlock, Coord coord) {
        try {
            this.world.func_180501_a(this.getBlockPos(coord), metaBlock.getState(), metaBlock.getFlag());
        }
        catch (NullPointerException npe) {
            LogManager.getLogger((String)"roguelike").error((Object)npe);
        }
        this.stats.merge(metaBlock.getBlock(), 1, Integer::sum);
        return true;
    }

    @Override
    public boolean isAirBlock(Coord pos) {
        return this.world.func_175623_d(this.getBlockPos(pos));
    }

    @Override
    public long getSeed() {
        return this.world.func_72905_C();
    }

    @Override
    public Random getSeededRandom(int a, int b, int c) {
        return this.world.func_72843_D(a, b, c);
    }

    @Override
    public void spiralStairStep(Random rand, Coord origin, StairsBlock stair, BlockBrush fill) {
        Coord start = origin.copy();
        start.translate(new Coord(-1, 0, -1));
        Coord end = origin.copy();
        end.translate(new Coord(1, 0, 1));
        RectSolid.newRect(start, end).fill(this, SingleBlockBrush.AIR);
        fill.stroke(this, origin);
        Direction dir = Direction.CARDINAL.get(origin.getY() % 4);
        Coord cursor = origin.copy();
        cursor.translate(dir);
        stair.setUpsideDown(false).setFacing(dir.antiClockwise()).stroke(this, cursor);
        cursor.translate(dir.clockwise());
        stair.setUpsideDown(true).setFacing(dir.clockwise()).stroke(this, cursor);
        cursor.translate(dir.reverse());
        stair.setUpsideDown(true).setFacing(dir.reverse()).stroke(this, cursor);
    }

    @Override
    public void fillDown(Coord origin, BlockBrush blocks) {
        Coord cursor = origin.copy();
        while (!this.isOpaqueCubeBlock(cursor) && cursor.getY() > 1) {
            blocks.stroke(this, cursor);
            cursor.down();
        }
    }

    @Override
    public TileEntity getTileEntity(Coord pos) {
        return this.world.func_175625_s(this.getBlockPos(pos));
    }

    @Override
    public boolean validGroundBlock(Coord pos) {
        return !invalid.contains(this.getBlockStateAt(pos).func_185904_a());
    }

    @Override
    public int getStat(Block type) {
        if (!this.stats.containsKey(type)) {
            return 0;
        }
        return this.stats.get(type);
    }

    @Override
    public Map<Block, Integer> getStats() {
        return this.stats;
    }

    @Override
    public boolean canPlace(SingleBlockBrush block, Coord pos, Direction dir) {
        return this.isAirBlock(pos) && BlockMapper1_12.map(block.getBlockType()).getBlock().func_176198_a(this.world, this.getBlockPos(pos), dir.getFacing());
    }

    @Override
    public PositionInfo getInfo(Coord pos) {
        return new PositionInfo1_12(this.world, pos);
    }

    @Override
    public Coord findNearestStructure(VanillaStructure type, Coord pos) {
        ChunkProviderServer chunkProvider = ((WorldServer)this.world).func_72863_F();
        String structureName = VanillaStructure.getName(type);
        BlockPos structurebp = null;
        try {
            structurebp = chunkProvider.func_180513_a(this.world, structureName, this.getBlockPos(pos), false);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (structurebp == null) {
            return null;
        }
        return new Coord(structurebp.func_177958_n(), structurebp.func_177956_o(), structurebp.func_177952_p());
    }

    public String toString() {
        return this.stats.entrySet().stream().map(pair -> ((Block)pair.getKey()).func_149732_F() + ": " + pair.getValue() + "\n").collect(Collectors.joining());
    }

    @Override
    public TreasureChestEditor getTreasureChestEditor() {
        return this.treasureChestEditor;
    }

    @Override
    public void setBedColorAt(Coord cursor, DyeColor color) {
        TileEntity tileEntity = this.getTileEntity(cursor);
        if (tileEntity instanceof TileEntityBed) {
            ((TileEntityBed)tileEntity).func_193052_a(DyeColor.get(color));
        } else {
            System.out.printf("Failed to paint bed at position %s to become color %s. Current block at position is %s%n", new Object[]{cursor, color, this.getBlockStateAt(cursor)});
        }
    }

    @Override
    public void setItem(Coord pos, int slot, RldItemStack itemStack) {
        this.setItem(pos, slot, ItemMapper1_12.map(itemStack));
    }

    @Override
    public void setItem(Coord pos, int slot, ItemStack itemStack) {
        TileEntity tileEntity = this.getTileEntity(pos);
        if (tileEntity == null) {
            return;
        }
        if (!(tileEntity instanceof TileEntityLockableLoot)) {
            return;
        }
        try {
            ((TileEntityLockableLoot)tileEntity).func_70299_a(slot, itemStack);
        }
        catch (NullPointerException nullPointerException) {
            System.out.printf("Could not place item %s at position %s. BlockState at pos: %s%n", itemStack, pos, this.getBlockStateAt(pos));
        }
    }

    @Override
    public void setFlowerPotContent(Coord pos, Plant choice) {
        TileEntity potEntity = this.getTileEntity(pos);
        if (potEntity == null) {
            return;
        }
        if (!(potEntity instanceof TileEntityFlowerPot)) {
            return;
        }
        TileEntityFlowerPot flowerPot = (TileEntityFlowerPot)potEntity;
        ItemStack flowerItem = WorldEditor1_12.getFlowerItem(choice);
        flowerPot.func_190614_a(flowerItem);
    }

    private static ItemStack getFlowerItem(Plant type) {
        switch (type) {
            case POPPY: {
                return new ItemStack((Block)Blocks.field_150328_O, 1, 0);
            }
            case ORCHID: {
                return new ItemStack((Block)Blocks.field_150328_O, 1, 1);
            }
            case ALLIUM: {
                return new ItemStack((Block)Blocks.field_150328_O, 1, 2);
            }
            case BLUET: {
                return new ItemStack((Block)Blocks.field_150328_O, 1, 3);
            }
            case REDTULIP: {
                return new ItemStack((Block)Blocks.field_150328_O, 1, 4);
            }
            case ORANGETULIP: {
                return new ItemStack((Block)Blocks.field_150328_O, 1, 5);
            }
            case WHITETULIP: {
                return new ItemStack((Block)Blocks.field_150328_O, 1, 6);
            }
            case PINKTULIP: {
                return new ItemStack((Block)Blocks.field_150328_O, 1, 7);
            }
            case DAISY: {
                return new ItemStack((Block)Blocks.field_150328_O, 1, 8);
            }
            case RED_MUSHROOM: {
                return new ItemStack((Block)Blocks.field_150337_Q);
            }
            case BROWN_MUSHROOM: {
                return new ItemStack((Block)Blocks.field_150338_P);
            }
            case CACTUS: {
                return new ItemStack((Block)Blocks.field_150434_aF);
            }
            case OAK_SAPLING: {
                return new ItemStack(Blocks.field_150345_g, 1, 0);
            }
            case SPRUCE_SAPLING: {
                return new ItemStack(Blocks.field_150345_g, 1, 1);
            }
            case BIRCH_SAPLING: {
                return new ItemStack(Blocks.field_150345_g, 1, 2);
            }
            case JUNGLE_SAPLING: {
                return new ItemStack(Blocks.field_150345_g, 1, 3);
            }
            case ACACIA_SAPLING: {
                return new ItemStack(Blocks.field_150345_g, 1, 4);
            }
            case DARKOAK_SAPLING: {
                return new ItemStack(Blocks.field_150345_g, 1, 5);
            }
            case SHRUB: {
                return new ItemStack((Block)Blocks.field_150329_H, 1, 0);
            }
            case FERN: {
                return new ItemStack((Block)Blocks.field_150329_H, 1, 2);
            }
        }
        return new ItemStack((Block)Blocks.field_150327_N);
    }

    @Override
    public void setLootTable(Coord pos, String table) {
        ((TileEntityChest)this.getTileEntity(pos)).func_189404_a(new ResourceLocation(table), (long)this.getSeed(pos));
    }

    @Override
    public int getCapacity(TreasureChest treasureChest) {
        return ((TileEntityLockableLoot)this.getTileEntity(treasureChest.getPos())).func_70302_i_();
    }

    @Override
    public boolean isEmptySlot(TreasureChest treasureChest, int slot) {
        return ((TileEntityLockableLoot)this.getTileEntity(treasureChest.getPos())).func_70301_a(slot).func_190926_b();
    }
}

