/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.item;

import com.github.fnar.minecraft.item.EquipmentType;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.Slot;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;

public enum ArmourType {
    HELMET,
    CHESTPLATE,
    LEGGINGS,
    BOOTS;


    public static ArmourType random(Random random) {
        int choice = random.nextInt(ArmourType.values().length);
        return ArmourType.values()[choice];
    }

    public Item asItem(Quality quality) {
        switch (this) {
            case HELMET: {
                return EquipmentType.asItem(quality, (Item)Items.field_151024_Q, (Item)Items.field_151020_U, (Item)Items.field_151169_ag, (Item)Items.field_151028_Y, (Item)Items.field_151161_ac);
            }
            case CHESTPLATE: {
                return EquipmentType.asItem(quality, (Item)Items.field_151027_R, (Item)Items.field_151023_V, (Item)Items.field_151171_ah, (Item)Items.field_151030_Z, (Item)Items.field_151163_ad);
            }
            case LEGGINGS: {
                return EquipmentType.asItem(quality, (Item)Items.field_151026_S, (Item)Items.field_151022_W, (Item)Items.field_151149_ai, (Item)Items.field_151165_aa, (Item)Items.field_151173_ae);
            }
            case BOOTS: {
                return EquipmentType.asItem(quality, (Item)Items.field_151021_T, (Item)Items.field_151029_X, (Item)Items.field_151151_aj, (Item)Items.field_151167_ab, (Item)Items.field_151175_af);
            }
        }
        throw new IllegalArgumentException("Unexpected ArmourType: " + (Object)((Object)this));
    }

    public Equipment asEquipment() {
        switch (this) {
            case HELMET: {
                return Equipment.HELMET;
            }
            case CHESTPLATE: {
                return Equipment.CHEST;
            }
            case LEGGINGS: {
                return Equipment.LEGS;
            }
            case BOOTS: {
                return Equipment.FEET;
            }
        }
        throw new IllegalArgumentException("Unexpected ArmourType: " + (Object)((Object)this));
    }

    public Slot asSlot() {
        switch (this) {
            case HELMET: {
                return Slot.HEAD;
            }
            case CHESTPLATE: {
                return Slot.CHEST;
            }
            case LEGGINGS: {
                return Slot.LEGS;
            }
            case BOOTS: {
                return Slot.FEET;
            }
        }
        throw new IllegalArgumentException("Unexpected ArmourType: " + (Object)((Object)this));
    }
}

