/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.item;

import com.github.fnar.minecraft.item.EquipmentType;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;

public enum WeaponType {
    BOW,
    SWORD;


    public static Item getBowItem() {
        return Items.field_151031_f;
    }

    public static Item getSwordItem(Quality quality) {
        return SWORD.asItem(quality);
    }

    public static WeaponType random(Random random) {
        int choice = random.nextInt(WeaponType.values().length);
        return WeaponType.values()[choice];
    }

    public Item asItem(Quality quality) {
        switch (this) {
            case BOW: {
                return EquipmentType.asItem(quality, (Item)Items.field_151031_f, (Item)Items.field_151031_f, (Item)Items.field_151031_f, (Item)Items.field_151031_f, (Item)Items.field_151031_f);
            }
            case SWORD: {
                return EquipmentType.asItem(quality, Items.field_151041_m, Items.field_151052_q, Items.field_151040_l, Items.field_151010_B, Items.field_151048_u);
            }
        }
        throw new IllegalArgumentException("Unexpected WeaponType: " + (Object)((Object)this));
    }

    public Equipment asEquipment() {
        switch (this) {
            case BOW: {
                return Equipment.BOW;
            }
            case SWORD: {
                return Equipment.SWORD;
            }
        }
        throw new IllegalArgumentException("Unexpected WeaponType: " + (Object)((Object)this));
    }
}

