/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.loot.special.armour;

import com.github.fnar.roguelike.loot.special.armour.SpecialArmour;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;

public class SpecialChestplate
extends SpecialArmour {
    public SpecialChestplate(Random random, int level) {
        this(random, ItemArmour.rollArmourQuality(random, level));
    }

    public SpecialChestplate(Random random, Quality quality) {
        this.withQuality(quality);
        this.withItem((Item)this.getChestplateItem());
        this.withName(this.getChestplateName());
        this.withChestplateEnchantments(random);
        this.withCommonEnchantments(random);
        this.withArmourPrefix();
        this.withRandomColourIfWood();
    }

    private void withChestplateEnchantments(Random random) {
        this.withArmorEnchantments(random);
    }

    private ItemArmor getChestplateItem() {
        switch (this.quality) {
            case DIAMOND: {
                return Items.field_151163_ad;
            }
            case GOLD: {
                return Items.field_151171_ah;
            }
            case IRON: {
                return Items.field_151030_Z;
            }
            case STONE: {
                return Items.field_151023_V;
            }
        }
        return Items.field_151027_R;
    }

    private String getChestplateName() {
        switch (this.quality) {
            case DIAMOND: {
                return "Plate";
            }
            case GOLD: 
            case IRON: {
                return "Cuirass";
            }
            case STONE: {
                return "Hauberk";
            }
        }
        return "Tunic";
    }
}

