/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.loot.special.tools;

import com.github.fnar.roguelike.loot.special.SpecialEquipment;
import com.github.fnar.roguelike.loot.special.tools.SpecialAxe;
import com.github.fnar.roguelike.loot.special.tools.SpecialHoe;
import com.github.fnar.roguelike.loot.special.tools.SpecialPickaxe;
import com.github.fnar.roguelike.loot.special.tools.SpecialShovel;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemTool;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class SpecialTool
extends SpecialEquipment {
    public static ItemStack createTool(Random random, int level) {
        Quality quality = ItemTool.rollToolQuality(random, level);
        return SpecialTool.createTool(random, quality);
    }

    public static ItemStack createTool(Random random, Quality quality) {
        return SpecialTool.chooseTool(random, quality).complete();
    }

    private static SpecialTool chooseTool(Random random, Quality quality) {
        switch (random.nextInt(4)) {
            case 0: {
                return new SpecialPickaxe(random, quality);
            }
            case 1: {
                return new SpecialAxe(random, quality);
            }
            case 2: {
                return new SpecialShovel(random, quality);
            }
        }
        return new SpecialHoe(random, quality);
    }

    protected void withFortune(Random random) {
        if (random.nextInt(10) != 0) {
            return;
        }
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return;
        }
        this.withEnchantment(Enchant.getEnchant(Enchant.FORTUNE), enchantmentLevel);
        this.withSuffix("of Prospecting");
    }

    protected void withSilkTouch(Random random) {
        if (random.nextInt(10) != 0) {
            return;
        }
        this.withEnchantment(Enchant.getEnchant(Enchant.SILKTOUCH), 1);
        this.withPrefix("Precision");
    }

    protected void withEfficiency(Random random) {
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return;
        }
        this.withEnchantment(Enchant.getEnchant(Enchant.EFFICIENCY), enchantmentLevel);
        if (enchantmentLevel >= 3) {
            this.withPrefix("Artisan's");
        }
    }

    protected SpecialTool withToolEnchantments(Random random) {
        this.withEfficiency(random);
        this.withSilkTouch(random);
        this.withFortune(random);
        return this;
    }
}

