/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.BaseRoom;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class CakeRoom
extends BaseRoom {
    public CakeRoom(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public BaseRoom generate(Coord origin, List<Direction> entrances) {
        Random random = this.worldEditor.getRandom(origin);
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        int HEIGHT = 3;
        int WIDTH = random.nextInt(2) + 2;
        int LENGTH = random.nextInt(2) + 3;
        RectSolid.newRect(new Coord(x - WIDTH, y, z - LENGTH), new Coord(x + WIDTH, y + 3, z + LENGTH)).fill(this.worldEditor, SingleBlockBrush.AIR);
        BlockBrush floor = this.levelSettings.getTheme().getPrimary().getFloor();
        RectHollow.newRect(origin.copy().west(WIDTH + 1).north(LENGTH + 1).down(), origin.copy().east(WIDTH + 1).south(LENGTH + 1).up(4)).fill(this.worldEditor, floor, false, true);
        BlockBrush pillar = this.levelSettings.getTheme().getPrimary().getPillar();
        RectSolid.newRect(new Coord(x - WIDTH, y, z - LENGTH), new Coord(x - WIDTH, y + 3, z - LENGTH)).fill(this.worldEditor, pillar);
        RectSolid.newRect(new Coord(x - WIDTH, y, z + LENGTH), new Coord(x - WIDTH, y + 3, z + LENGTH)).fill(this.worldEditor, pillar);
        RectSolid.newRect(new Coord(x + WIDTH, y, z - LENGTH), new Coord(x + WIDTH, y + 3, z - LENGTH)).fill(this.worldEditor, pillar);
        RectSolid.newRect(new Coord(x + WIDTH, y, z + LENGTH), new Coord(x + WIDTH, y + 3, z + LENGTH)).fill(this.worldEditor, pillar);
        BlockBrush lightBLock = this.levelSettings.getTheme().getPrimary().getLightBlock();
        lightBLock.stroke(this.worldEditor, new Coord(x - WIDTH + 1, y + 3 + 1, z - LENGTH + 1));
        lightBLock.stroke(this.worldEditor, new Coord(x - WIDTH + 1, y + 3 + 1, z + LENGTH - 1));
        lightBLock.stroke(this.worldEditor, new Coord(x + WIDTH - 1, y + 3 + 1, z - LENGTH + 1));
        lightBLock.stroke(this.worldEditor, new Coord(x + WIDTH - 1, y + 3 + 1, z + LENGTH - 1));
        this.placeCake(origin, pillar);
        ArrayList<Coord> spaces = new ArrayList<Coord>();
        spaces.add(new Coord(x - WIDTH, y, z - LENGTH + 1));
        spaces.add(new Coord(x - WIDTH, y, z + LENGTH - 1));
        spaces.add(new Coord(x + WIDTH, y, z - LENGTH + 1));
        spaces.add(new Coord(x + WIDTH, y, z + LENGTH - 1));
        List<Coord> chestLocations = this.chooseRandomLocations(1, spaces);
        this.worldEditor.getTreasureChestEditor().createChests(chestLocations, false, Dungeon.getLevel(y), entrances.get(0).reverse(), this.getRoomSetting().getChestType().orElse(ChestType.FOOD));
        this.generateDoorways(origin, entrances);
        return this;
    }

    public void placeCake(Coord origin, BlockBrush pillar) {
        Coord cakeStand = origin.copy();
        pillar.stroke(this.worldEditor, cakeStand);
        BlockType.CAKE.getBrush().stroke(this.worldEditor, cakeStand.up());
    }

    @Override
    public int getSize() {
        return 6;
    }
}

