/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.normal.ColoredBlock;
import com.github.fnar.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.base.BaseRoom;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.util.DyeColor;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DungeonsMusic
extends BaseRoom {
    public DungeonsMusic(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public BaseRoom generate(Coord origin, List<Direction> entrances) {
        Coord cursor;
        Random rand = this.worldEditor.getRandom(origin);
        Theme theme = this.levelSettings.getTheme();
        BlockBrush wall = theme.getPrimary().getWall();
        StairsBlock stair = theme.getSecondary().getStair();
        BlockBrush panel = theme.getSecondary().getWall();
        BlockBrush pillar = theme.getSecondary().getPillar();
        BlockBrush floor = theme.getSecondary().getFloor();
        ArrayList<Coord> chests = new ArrayList<Coord>();
        Coord start = origin.copy();
        Coord end = origin.copy();
        start.translate(new Coord(-6, -1, -6));
        end.translate(new Coord(6, 5, 6));
        RectHollow.newRect(start, end).fill(this.worldEditor, wall, false, true);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-6, 4, -6));
        end.translate(new Coord(6, 5, 6));
        RectSolid.newRect(start, end).fill(this.worldEditor, panel);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-3, 4, -3));
        end.translate(new Coord(3, 4, 3));
        RectSolid.newRect(start, end).fill(this.worldEditor, SingleBlockBrush.AIR);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-3, -1, -3));
        end.translate(new Coord(3, -1, 3));
        RectSolid.newRect(start, end).fill(this.worldEditor, floor);
        for (int i = 2; i >= 0; --i) {
            start = origin.copy();
            end = origin.copy();
            start.translate(new Coord(-i - 1, 0, -i - 1));
            end.translate(new Coord(i + 1, 0, i + 1));
            ColoredBlock carpet = ColoredBlock.carpet().setColor(DyeColor.chooseRandom(rand));
            RectSolid.newRect(start, end).fill(this.worldEditor, carpet);
        }
        for (Direction dir : Direction.CARDINAL) {
            cursor = origin.copy();
            cursor.translate(dir, 5);
            cursor.up(3);
            panel.stroke(this.worldEditor, cursor);
            cursor.translate(dir.reverse());
            stair.setUpsideDown(true).setFacing(dir.reverse()).stroke(this.worldEditor, cursor);
            cursor = origin.copy();
            cursor.translate(dir, 5);
            cursor.translate(dir.antiClockwise(), 5);
            this.pillar(this.worldEditor, this.levelSettings, cursor);
            start = origin.copy();
            start.up(4);
            start.translate(dir, 3);
            end = start.copy();
            start.translate(dir.antiClockwise(), 3);
            end.translate(dir.clockwise(), 3);
            RectSolid.newRect(start, end).fill(this.worldEditor, pillar);
            cursor = origin.copy();
            cursor.up(4);
            cursor.translate(dir);
            stair.setUpsideDown(true).setFacing(dir).stroke(this.worldEditor, cursor);
            cursor.translate(dir);
            stair.setUpsideDown(true).setFacing(dir.reverse()).stroke(this.worldEditor, cursor);
            for (Direction o : dir.orthogonals()) {
                cursor = origin.copy();
                cursor.translate(dir, 5);
                cursor.translate(o, 2);
                this.pillar(this.worldEditor, this.levelSettings, cursor);
                cursor = origin.copy();
                cursor.translate(dir, 4);
                cursor.up(3);
                cursor.translate(o);
                stair.setUpsideDown(true).setFacing(dir.reverse()).stroke(this.worldEditor, cursor);
                cursor = origin.copy();
                cursor.translate(dir, 5);
                cursor.translate(o, 3);
                cursor.up();
                chests.add(cursor.copy());
                cursor.translate(o);
                chests.add(cursor.copy());
                cursor = origin.copy();
                cursor.translate(dir, 5);
                cursor.translate(o, 3);
                stair.setUpsideDown(true).setFacing(dir.reverse()).stroke(this.worldEditor, cursor);
                cursor.translate(o);
                stair.setUpsideDown(true).setFacing(dir.reverse()).stroke(this.worldEditor, cursor);
                cursor.up(2);
                stair.setUpsideDown(true).setFacing(o.reverse()).stroke(this.worldEditor, cursor);
                cursor.translate(o.reverse());
                stair.setUpsideDown(true).setFacing(o).stroke(this.worldEditor, cursor);
                cursor.up();
                panel.stroke(this.worldEditor, cursor);
                cursor.translate(o);
                panel.stroke(this.worldEditor, cursor);
                cursor.translate(dir.reverse());
                stair.setUpsideDown(true).setFacing(dir.reverse()).stroke(this.worldEditor, cursor);
                cursor.translate(o.reverse());
                stair.setUpsideDown(true).setFacing(dir.reverse()).stroke(this.worldEditor, cursor);
            }
        }
        BlockType.JUKEBOX.getBrush().stroke(this.worldEditor, origin);
        cursor = origin.copy();
        cursor.up(4);
        this.levelSettings.getTheme().getPrimary().getLightBlock().stroke(this.worldEditor, cursor);
        List<Coord> chestLocations = this.chooseRandomLocations(1, chests);
        this.worldEditor.getTreasureChestEditor().createChests(chestLocations, false, this.levelSettings.getDifficulty(origin), entrances.get(0).reverse(), this.getRoomSetting().getChestType().orElse(ChestType.MUSIC));
        this.generateDoorways(origin, entrances);
        return this;
    }

    private void pillar(WorldEditor editor, LevelSettings settings, Coord origin) {
        Theme theme = settings.getTheme();
        StairsBlock stair = theme.getSecondary().getStair();
        BlockBrush panel = theme.getSecondary().getWall();
        BlockBrush pillar = theme.getSecondary().getPillar();
        Coord start = origin.copy();
        Coord end = start.copy();
        end.up(2);
        RectSolid.newRect(start, end).fill(editor, pillar);
        for (Direction dir : Direction.CARDINAL) {
            Coord cursor = end.copy();
            cursor.translate(dir);
            stair.setUpsideDown(true).setFacing(dir).stroke(editor, cursor, true, false);
            cursor.up();
            panel.stroke(editor, cursor);
        }
    }

    @Override
    public int getSize() {
        return 8;
    }
}

