/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.decorative.TorchBlock;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.BaseRoom;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DungeonsPit
extends BaseRoom {
    Random rand;
    int originX;
    int originY;
    int originZ;
    byte dungeonHeight = (byte)3;
    int dungeonLength = 2;
    int dungeonWidth = 2;
    int woolColor;
    int numChests;
    BlockBrush blocks;

    public DungeonsPit(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public BaseRoom generate(Coord origin, List<Direction> entrances) {
        Theme theme = this.levelSettings.getTheme();
        this.rand = this.worldEditor.getRandom(origin);
        this.originX = origin.getX();
        this.originY = origin.getY();
        this.originZ = origin.getZ();
        this.blocks = theme.getPrimary().getWall();
        this.buildWalls();
        this.buildFloor();
        this.buildRoof();
        this.buildPit();
        for (Direction dir : Direction.CARDINAL) {
            this.setTrap(this.worldEditor, this.levelSettings, dir, origin);
        }
        ArrayList<Coord> spaces = new ArrayList<Coord>();
        spaces.add(new Coord(this.originX - 2, this.originY, this.originZ - 2));
        spaces.add(new Coord(this.originX - 2, this.originY, this.originZ + 2));
        spaces.add(new Coord(this.originX + 2, this.originY, this.originZ - 2));
        spaces.add(new Coord(this.originX + 2, this.originY, this.originZ + 2));
        List<Coord> chestLocations = this.chooseRandomLocations(1, spaces);
        this.worldEditor.getTreasureChestEditor().createChests(chestLocations, false, Dungeon.getLevel(this.originY), entrances.get(0), this.getRoomSetting().getChestType().orElse(ChestType.chooseRandomAmong(this.rand, ChestType.COMMON_TREASURES)));
        return this;
    }

    protected void buildWalls() {
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockY = this.originY + this.dungeonHeight; blockY >= this.originY - 1; --blockY) {
                for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                    if (blockX == this.originX - this.dungeonLength - 1 || blockZ == this.originZ - this.dungeonWidth - 1 || blockX == this.originX + this.dungeonLength + 1 || blockZ == this.originZ + this.dungeonWidth + 1) {
                        if (blockY >= 0 && !this.worldEditor.isSolidBlock(new Coord(blockX, blockY - 1, blockZ))) {
                            SingleBlockBrush.AIR.stroke(this.worldEditor, new Coord(blockX, blockY, blockZ));
                            continue;
                        }
                        if (!this.worldEditor.isSolidBlock(new Coord(blockX, blockY, blockZ))) continue;
                        this.blocks.stroke(this.worldEditor, new Coord(blockX, blockY, blockZ));
                        continue;
                    }
                    SingleBlockBrush.AIR.stroke(this.worldEditor, new Coord(blockX, blockY, blockZ));
                }
            }
        }
    }

    protected void buildFloor() {
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                this.blocks.stroke(this.worldEditor, new Coord(blockX, this.originY - 1, blockZ));
            }
        }
    }

    protected void buildRoof() {
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                this.blocks.stroke(this.worldEditor, new Coord(blockX, this.dungeonHeight + 1, blockZ));
            }
        }
    }

    private void buildPit() {
        for (int x = this.originX - 2; x <= this.originX + 2; ++x) {
            for (int z = this.originZ - 2; z <= this.originZ + 2; ++z) {
                for (int y = this.originY - 1; y > 0; --y) {
                    Coord pos = new Coord(x, y, z);
                    if (this.worldEditor.isAirBlock(pos) || y < this.rand.nextInt(5) && this.worldEditor.isBlockOfTypeAt(BlockType.BEDROCK, pos)) continue;
                    if (x == this.originX - 2 || x == this.originX + 2 || z == this.originZ - 2 || z == this.originZ + 2) {
                        this.blocks.stroke(this.worldEditor, pos);
                        continue;
                    }
                    if (y < 10) {
                        BlockType.WATER_FLOWING.getBrush().stroke(this.worldEditor, pos);
                        continue;
                    }
                    SingleBlockBrush.AIR.stroke(this.worldEditor, pos);
                }
            }
        }
    }

    private void setTrap(WorldEditor editor, LevelSettings settings, Direction dir, Coord origin) {
        Theme theme = settings.getTheme();
        BlockBrush walls = theme.getPrimary().getWall();
        SingleBlockBrush plate = BlockType.PRESSURE_PLATE_STONE.getBrush();
        SingleBlockBrush wire = BlockType.REDSTONE_WIRE.getBrush();
        Coord start = origin.copy();
        start.translate(dir, 3);
        start.down();
        start.translate(dir.antiClockwise());
        Coord end = origin.copy();
        end.translate(dir, 6);
        end.up(3);
        end.translate(dir.clockwise());
        for (Coord cell : new RectHollow(start, end)) {
            if (editor.isAirBlock(cell)) {
                return;
            }
            walls.stroke(editor, cell);
        }
        Coord cursor = origin.copy();
        cursor.translate(dir, 2);
        plate.stroke(editor, cursor);
        cursor = origin.copy();
        cursor.down();
        cursor.translate(dir, 3);
        TorchBlock.redstone().setFacing(dir).stroke(editor, cursor);
        cursor.translate(dir);
        wire.stroke(editor, cursor);
        cursor.up();
        cursor.translate(dir);
        TorchBlock.redstone().extinguish().setFacing(Direction.UP).stroke(editor, cursor);
        cursor.translate(dir.reverse());
        cursor.up();
        BlockType.STICKY_PISTON.getBrush().setFacing(dir).stroke(editor, cursor);
    }

    @Override
    public int getSize() {
        return 4;
    }
}

