/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import greymerk.roguelike.worldgen.spawners.SpawnerSettings;
import java.util.Random;

public class SegmentSpawner
extends SegmentBase {
    @Override
    protected void genWall(WorldEditor editor, Random rand, DungeonLevel level, Direction dir, Theme theme, Coord origin) {
        Direction[] orthogonals = dir.orthogonals();
        Coord start = origin.copy().translate(dir, 2).translate(orthogonals[0], 1);
        Coord end = origin.copy().translate(dir, 2).translate(orthogonals[1], 1).up(2);
        RectSolid.newRect(start, end).fill(editor, SingleBlockBrush.AIR).translate(dir, 1).fill(editor, theme.getSecondary().getWall());
        this.generateDecorativeArch(editor, dir, origin, theme);
        this.generateSpawner(editor, rand, level, dir, origin, theme);
    }

    private void generateDecorativeArch(WorldEditor editor, Direction dir, Coord origin, Theme theme) {
        for (Direction orthogonal : dir.orthogonals()) {
            Coord cursor = origin.copy().up(2).translate(dir, 2).translate(orthogonal, 1);
            theme.getSecondary().getStair().setUpsideDown(true).setFacing(orthogonal.reverse()).stroke(editor, cursor);
        }
    }

    private void generateSpawner(WorldEditor editor, Random rand, DungeonLevel level, Direction dir, Coord origin, Theme theme) {
        Coord spawnerCoord = origin.copy().translate(dir, 4).up(1);
        int difficulty = level.getSettings().getDifficulty(spawnerCoord);
        SpawnerSettings spawners = level.getSettings().getSpawners().isEmpty() ? MobType.newSpawnerSetting(MobType.COMMON_MOBS) : level.getSettings().getSpawners();
        spawners.generateSpawner(editor, spawnerCoord, difficulty);
        BlockBrush panelInFrontOfSpawner = rand.nextInt(Math.max(1, difficulty)) == 0 ? BlockType.GLASS.getBrush() : theme.getSecondary().getWall();
        panelInFrontOfSpawner.stroke(editor, spawnerCoord.translate(dir.reverse()));
    }
}

