/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.monster;

import com.github.fnar.minecraft.item.ArmourType;
import com.github.fnar.minecraft.item.Arrow;
import com.github.fnar.minecraft.item.ItemMapper1_12;
import com.github.fnar.roguelike.loot.special.armour.SpecialArmour;
import com.github.fnar.util.Color;
import greymerk.roguelike.monster.MobType;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Shield;
import greymerk.roguelike.treasure.loot.Slot;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import greymerk.roguelike.treasure.loot.provider.ItemWeapon;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public interface IEntity {
    default public void equipArmor(World world, Random rand, int level, Color color) {
        Arrays.stream(ArmourType.values()).forEach(armourType -> {
            EntityEquipmentSlot slot = Slot.getSlot(armourType.asSlot());
            int enchantLevel = Enchant.canEnchant(world.func_175659_aa(), rand, level) ? Enchant.getLevel(rand, level) : 0;
            boolean isSpecialArmour = enchantLevel > 0 && rand.nextInt(20 + level * 10) == 0;
            ItemStack item = isSpecialArmour ? SpecialArmour.createArmour(rand, level) : ItemArmour.getRandom(rand, level, enchantLevel, armourType, color);
            this.setSlot(slot, item);
        });
    }

    default public void equipBow(World world, Random random, int level) {
        this.equipMainhand(ItemWeapon.getBow(random, level, Enchant.canEnchant(world.func_175659_aa(), random, level)));
    }

    default public void equipArrows(Arrow arrow) {
        this.equipOffhand(ItemMapper1_12.map(arrow.asItemStack()));
    }

    default public void equipShield(Random rand) {
        this.equipOffhand(Shield.get(rand));
    }

    default public void equipOffhand(ItemStack item) {
        this.setSlot(EntityEquipmentSlot.OFFHAND, item);
    }

    default public void equipMainhand(ItemStack itemStack) {
        this.setSlot(EntityEquipmentSlot.MAINHAND, itemStack);
    }

    public void setSlot(EntityEquipmentSlot var1, ItemStack var2);

    public void setMobClass(MobType var1, boolean var2);

    public void setChild(boolean var1);

    public boolean instance(Class<?> var1);

    public void setName(String var1);
}

