/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure;

import com.google.common.base.Predicates;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.util.IWeighted;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;

public class TreasureManager {
    List<TreasureChest> chests = new ArrayList<TreasureChest>();
    private Random random;

    public TreasureManager(Random random) {
        this.random = random;
    }

    public void addChest(TreasureChest toAdd) {
        this.chests.add(toAdd);
    }

    public void addItemToAll(Predicate<TreasureChest> chestPredicate, IWeighted<ItemStack> items, int amount) {
        this.findChests(chestPredicate).forEach(chest -> IntStream.range(0, amount).mapToObj(i -> (ItemStack)items.get(this.random)).forEach(chest::setRandomEmptySlot));
    }

    public void addItem(Predicate<TreasureChest> chestPredicate, IWeighted<ItemStack> items, int amount) {
        List<TreasureChest> chests = this.findChests(chestPredicate);
        if (chests.isEmpty()) {
            return;
        }
        IntStream.range(0, amount).mapToObj(i -> (ItemStack)items.get(this.random)).forEach(item -> this.addItemToRandomChest(chests, (ItemStack)item));
    }

    private void addItemToRandomChest(List<TreasureChest> chests, ItemStack item) {
        chests.get(this.random.nextInt(chests.size())).setRandomEmptySlot(item);
    }

    public List<TreasureChest> findChests(Predicate<TreasureChest> predicate) {
        return this.chests.stream().filter(predicate).collect(Collectors.toList());
    }

    public static Predicate<TreasureChest> ofType(ChestType chestType) {
        return chest -> chest.getType().equals(chestType);
    }

    public static Predicate<TreasureChest> ofTypeOnLevel(ChestType chestType, int level) {
        return Predicates.and(chest -> chest.getLevel() == level, chest -> chest.getType().equals(chestType));
    }

    public static Predicate<TreasureChest> onLevel(int level) {
        return Predicates.and(TreasureChest::isNotEmpty, chest -> chest.getLevel() == level);
    }
}

