/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.item.ItemStack;

public enum ItemHideFlags {
    ENCHANTMENTS,
    ATTRIBUTES,
    UNBREAKABLE,
    CANDESTROY,
    CANPLACEON,
    EFFECTS;


    public static void set(ItemHideFlags[] flags, ItemStack item) {
        Optional.ofNullable(item.func_77978_p()).ifPresent(nbt -> ItemHideFlags.reduce(flags).ifPresent(value -> nbt.func_74768_a("HideFlags", value.intValue())));
    }

    public static Optional<Integer> reduce(ItemHideFlags[] flags) {
        return Arrays.stream(flags).map(ItemHideFlags::get).reduce(Integer::sum);
    }

    public static void set(ItemHideFlags flag, ItemStack item) {
        ItemHideFlags.set(new ItemHideFlags[]{flag}, item);
    }

    public static int get(ItemHideFlags flag) {
        switch (flag) {
            case ENCHANTMENTS: {
                return 1;
            }
            case ATTRIBUTES: {
                return 2;
            }
            case UNBREAKABLE: {
                return 4;
            }
            case CANDESTROY: {
                return 8;
            }
            case CANPLACEON: {
                return 16;
            }
            case EFFECTS: {
                return 32;
            }
        }
        return 0;
    }
}

