/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.settings.DungeonSettingParseException;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.BlockCheckers;
import greymerk.roguelike.worldgen.BlockColumns;
import greymerk.roguelike.worldgen.BlockJumble;
import greymerk.roguelike.worldgen.BlockLayers;
import greymerk.roguelike.worldgen.BlockStripes;
import greymerk.roguelike.worldgen.BlockWeightedRandom;

public enum BlockProvider {
    METABLOCK,
    WEIGHTED,
    CHECKERS,
    JUMBLE,
    STRIPES,
    LAYERS,
    COLUMNS;


    public static BlockBrush create(JsonObject block) throws DungeonSettingParseException {
        BlockProvider type = block.has("type") ? BlockProvider.valueOf(block.get("type").getAsString()) : METABLOCK;
        JsonObject data = block.has("data") ? block.get("data") : block;
        switch (type) {
            case METABLOCK: {
                return new SingleBlockBrush((JsonElement)data);
            }
            case WEIGHTED: {
                return new BlockWeightedRandom((JsonElement)data);
            }
            case CHECKERS: {
                return new BlockCheckers((JsonElement)data);
            }
            case JUMBLE: {
                return new BlockJumble((JsonElement)data);
            }
            case STRIPES: {
                return new BlockStripes((JsonElement)data);
            }
            case LAYERS: {
                return new BlockLayers((JsonElement)data);
            }
            case COLUMNS: {
                return new BlockColumns((JsonElement)data);
            }
        }
        return null;
    }
}

