/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import com.endertech.common.CommonTime;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class CachedValue<V> {
    protected V cachedValue = null;
    protected CommonTime.Stamp lastUpdate = CommonTime.Stamp.now();
    protected final CommonTime.Interval updateInterval;
    protected final Supplier<V> valueSupplier;

    public static <V> CachedValue<V> of(Supplier<V> valueSupplier, CommonTime.Interval updateInterval) {
        return new CachedValue<V>(updateInterval, valueSupplier);
    }

    @Deprecated
    public CachedValue(V initialValue, CommonTime.Interval updateInterval) {
        this(updateInterval, () -> initialValue);
    }

    public CachedValue(CommonTime.Interval updateInterval, Supplier<V> valueSupplier) {
        this.updateInterval = updateInterval;
        this.valueSupplier = valueSupplier;
    }

    protected boolean requiresUpdate() {
        return this.cachedValue == null || CommonTime.Interval.passedFrom(this.lastUpdate).moreThan(this.updateInterval);
    }

    protected V updateAndReturn(V value) {
        this.cachedValue = value;
        this.lastUpdate = CommonTime.Stamp.now();
        return this.cachedValue;
    }

    public V get() {
        return this.requiresUpdate() ? this.updateAndReturn(this.valueSupplier.get()) : this.cachedValue;
    }

    public <P1, P2> V get(BiFunction<P1, P2, V> updatedValue, P1 param1, P2 param2) {
        return this.requiresUpdate() ? this.updateAndReturn(updatedValue.apply(param1, param2)) : this.cachedValue;
    }

    public <P> V get(Function<P, V> updatedValue, P param) {
        return this.requiresUpdate() ? this.updateAndReturn(updatedValue.apply(param)) : this.cachedValue;
    }
}

