/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.math.ForgeMath;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class ForgeEntity
extends Entity {
    public ForgeEntity(World world) {
        super(world);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tag) {
    }

    protected void func_70014_b(NBTTagCompound tag) {
    }

    public Vect3d getBBCenter() {
        return ForgeMath.getBBCenter(this.getBB());
    }

    public static Vect3d getCenteredPosTo(BlockPos pos) {
        return ForgeWorld.getBlockCenter(pos).withY(pos.func_177956_o());
    }

    public static Vect3d getCenterPosition(Entity entity) {
        return ForgeMath.getBBCenter(ForgeEntity.getBB(entity));
    }

    public static Vect3d getCenterPosition(Entity entity, float tickProgress) {
        return ForgeMath.getBBCenter(ForgeEntity.getBB(entity, ForgeEntity.getCurPosition(entity, tickProgress)));
    }

    public static Entity findEntity(World world, int id) {
        return world != null ? world.func_73045_a(id) : null;
    }

    public static void setCollisionReduction(Entity entity, float factor) {
        if (entity != null) {
            entity.field_70144_Y = factor;
        }
    }

    public static Vect3d getMotion(Entity entity) {
        return entity != null ? Vect3d.from(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y) : Vect3d.ZERO;
    }

    public Vect3d getMotion() {
        return ForgeEntity.getMotion(this);
    }

    public static void setMotion(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            boolean motionChanged = ForgeEntity.getMotion(entity).notEqual(vec);
            entity.field_70159_w = vec.x;
            entity.field_70181_x = vec.y;
            entity.field_70179_y = vec.z;
            if (motionChanged) {
                entity.field_70133_I = true;
            }
        }
    }

    public void setMotion(Vect3d vec) {
        ForgeEntity.setMotion(this, vec);
    }

    public void move() {
        this.setPrevPosition(this.getCurPosition());
        this.setCurPosition(this.getCurPosition().add(this.getMotion()));
    }

    public static void addMotion(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            ForgeEntity.setMotion(entity, ForgeEntity.getMotion(entity).add(vec));
        }
    }

    public void addMotion(Vect3d vec) {
        ForgeEntity.addMotion(this, vec);
    }

    public static void copyAllPositionsWithOffset(Entity source, Entity target, Vect3d offset) {
        if (source != null && target != null) {
            ForgeEntity.setPrevPosition(target, ForgeEntity.getPrevPosition(source).add(offset));
            ForgeEntity.setLastTickPosition(target, ForgeEntity.getLastTickPosition(source).add(offset));
            ForgeEntity.setCurPosition(target, ForgeEntity.getCurPosition(source).add(offset));
        }
    }

    public static BlockPos getPosition(Entity entity) {
        return new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public static Vect3d getCurPosition(Entity entity) {
        return entity != null ? Vect3d.from(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) : Vect3d.ZERO;
    }

    public static Vect3d getCurPosition(Entity entity, float tickProgress) {
        return Vect3d.approx(tickProgress, ForgeEntity.getLastTickPosition(entity), ForgeEntity.getCurPosition(entity));
    }

    public Vect3d getCurPosition() {
        return ForgeEntity.getCurPosition(this);
    }

    public Vect3d getCurPosition(float tickProgress) {
        return ForgeEntity.getCurPosition(this, tickProgress);
    }

    public static BlockPos getPositionEyes(Entity entity) {
        double y = entity.field_70163_u + (double)entity.func_70047_e();
        BlockPos pos = new BlockPos(entity.field_70165_t, y, entity.field_70161_v);
        return pos;
    }

    public static BlockPos getPositionTop(Entity entity) {
        double y = entity.field_70163_u + (double)entity.field_70131_O;
        BlockPos pos = new BlockPos(entity.field_70165_t, y, entity.field_70161_v);
        return pos;
    }

    public static Rotation getPrevRotation(Entity entity) {
        return entity != null ? new Rotation(entity.field_70127_C, entity.field_70126_B) : Rotation.ZERO;
    }

    public static Rotation getRotation(Entity entity) {
        return entity != null ? new Rotation(entity.field_70125_A, entity.field_70177_z) : Rotation.ZERO;
    }

    public static Rotation getRotation(Entity entity, float tickProgress) {
        return ForgeEntity.getPrevRotation(entity).approx(tickProgress, ForgeEntity.getRotation(entity));
    }

    public Rotation getRotation(float tickProgress) {
        return ForgeEntity.getRotation(this, tickProgress);
    }

    public Rotation getPrevRotation() {
        return ForgeEntity.getPrevRotation(this);
    }

    public Rotation getCurRotation() {
        return ForgeEntity.getRotation(this);
    }

    public static Vect3d getLastTickPosition(Entity entity) {
        return entity != null ? Vect3d.from(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U) : Vect3d.ZERO;
    }

    public Vect3d getLastTickPosition() {
        return ForgeEntity.getLastTickPosition(this);
    }

    public static Vect3d getPrevPosition(Entity entity) {
        return entity != null ? Vect3d.from(entity.field_70169_q, entity.field_70167_r, entity.field_70166_s) : Vect3d.ZERO;
    }

    public Vect3d getPrevPosition() {
        return ForgeEntity.getPrevPosition(this);
    }

    public static Vect3d getNextPosition(Entity entity) {
        return entity != null ? ForgeEntity.getCurPosition(entity).add(ForgeEntity.getMotion(entity)) : Vect3d.ZERO;
    }

    public static void swapPositionsOf(Entity entA, Entity entB) {
        if (entA != null && entB != null) {
            Vect3d prev = ForgeEntity.getPrevPosition(entA);
            Vect3d lastTick = ForgeEntity.getLastTickPosition(entA);
            Vect3d cur = ForgeEntity.getCurPosition(entA);
            ForgeEntity.setPrevPosition(entA, ForgeEntity.getPrevPosition(entB));
            ForgeEntity.setLastTickPosition(entA, ForgeEntity.getLastTickPosition(entB));
            ForgeEntity.setCurPosition(entA, ForgeEntity.getCurPosition(entB));
            ForgeEntity.setPrevPosition(entB, prev);
            ForgeEntity.setLastTickPosition(entB, lastTick);
            ForgeEntity.setCurPosition(entB, cur);
        }
    }

    public void swapPositionWith(Entity entity) {
        ForgeEntity.swapPositionsOf(this, entity);
    }

    public BlockPos func_180425_c() {
        return ForgeEntity.getPosition(this);
    }

    public Vect3d getNextPosition() {
        return ForgeEntity.getNextPosition(this);
    }

    public static void setCurPosition(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.func_70107_b(vec.x, vec.y, vec.z);
        }
    }

    public static void setPosition_NoBB(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.field_70165_t = vec.x;
            entity.field_70163_u = vec.y;
            entity.field_70161_v = vec.z;
        }
    }

    public static void setLastTickPosition(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.field_70142_S = vec.x;
            entity.field_70137_T = vec.y;
            entity.field_70136_U = vec.z;
        }
    }

    public void setLastTickPosition(Vect3d vec) {
        ForgeEntity.setLastTickPosition(this, vec);
    }

    public static void setPrevPosition(Entity entity, Vect3d vec) {
        ForgeEntity.setLastTickPosition(entity, vec);
        if (entity != null && vec != null) {
            entity.field_70169_q = vec.x;
            entity.field_70167_r = vec.y;
            entity.field_70166_s = vec.z;
        }
    }

    public void setPrevPosition(Vect3d vec) {
        ForgeEntity.setPrevPosition(this, vec);
    }

    public void setCurPosition(Vect3d vec) {
        ForgeEntity.setCurPosition(this, vec);
    }

    public static void setPrevRotation(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.field_70127_C = rotation.pitch;
            entity.field_70126_B = rotation.yaw;
        }
    }

    public void setPrevRotation(Rotation rotation) {
        ForgeEntity.setPrevRotation(this, rotation);
    }

    public static void setRotation(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.field_70125_A = rotation.pitch;
            entity.field_70177_z = rotation.yaw;
        }
    }

    public void setCurRotation(Rotation rotation) {
        ForgeEntity.setRotation(this, rotation);
    }

    public static void setAllPositions(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.field_70169_q = entity.field_70165_t = vec.x;
            entity.field_70142_S = entity.field_70165_t;
            entity.field_70167_r = entity.field_70163_u = vec.y;
            entity.field_70137_T = entity.field_70163_u;
            entity.field_70166_s = entity.field_70161_v = vec.z;
            entity.field_70136_U = entity.field_70161_v;
            ForgeEntity.setCurPosition(entity, vec);
        }
    }

    public void setAllPositions(Vect3d vec) {
        ForgeEntity.setAllPositions(this, vec);
    }

    public static void setAllRotations(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.field_70127_C = entity.field_70125_A = rotation.pitch;
            entity.field_70126_B = entity.field_70177_z = rotation.yaw;
        }
    }

    public void setAllRotations(Rotation rotation) {
        ForgeEntity.setAllRotations(this, rotation);
    }

    public static float getSize(Entity entity) {
        if (entity != null) {
            return entity.field_70130_N * entity.field_70131_O;
        }
        return 0.0f;
    }

    public static int getId(Entity entity) {
        return entity != null ? entity.func_145782_y() : -1;
    }

    public int getId() {
        return ForgeEntity.getId(this);
    }

    public float getSize() {
        return ForgeEntity.getSize(this);
    }

    public static Collection<Entity> getLowestRidingWithAllPassengers(Entity entity) {
        Collection<Object> collection = Collections.emptySet();
        if (entity != null) {
            Entity lowestRiding = entity.func_184208_bv();
            collection = lowestRiding.func_184182_bu();
            collection.add(lowestRiding);
        }
        return collection;
    }

    public static float getWeight(Entity entity, boolean includeAllConnected) {
        float weight = 0.0f;
        if (entity != null) {
            if (includeAllConnected) {
                for (Entity connected : ForgeEntity.getLowestRidingWithAllPassengers(entity)) {
                    weight += ForgeEntity.getWeight(connected, false);
                }
            } else {
                weight += ForgeEntity.getSize(entity);
            }
        }
        return weight;
    }

    public static EnumFacing getFacingTo(BlockPos targetPos, EntityLivingBase entity) {
        double dist = 2.0;
        if (Math.abs(entity.field_70165_t - (double)targetPos.func_177958_n()) < 2.0 && Math.abs(entity.field_70161_v - (double)targetPos.func_177952_p()) < 2.0) {
            double eyeY = entity.field_70163_u + (double)entity.func_70047_e();
            if (eyeY - (double)targetPos.func_177956_o() > 2.0) {
                return EnumFacing.DOWN;
            }
            if ((double)targetPos.func_177956_o() - eyeY > 0.0) {
                return EnumFacing.UP;
            }
        }
        return entity.func_174811_aO();
    }

    public static void setFallDistance(Entity entity, float distance, boolean includeAllConnected) {
        if (entity != null) {
            if (includeAllConnected) {
                for (Entity connected : ForgeEntity.getLowestRidingWithAllPassengers(entity)) {
                    ForgeEntity.setFallDistance(connected, distance, false);
                }
            } else {
                entity.field_70143_R = distance;
            }
        }
    }

    public static void updateBB(Entity entity) {
        if (entity != null) {
            entity.func_174826_a(ForgeEntity.getBB(entity, ForgeEntity.getCurPosition(entity)));
        }
    }

    public static AxisAlignedBB getBB(Entity entity, Vect3d position) {
        if (entity != null && position != null) {
            double widthHalf = (double)entity.field_70130_N / 2.0;
            return new AxisAlignedBB(position.x - widthHalf, position.y, position.z - widthHalf, position.x + widthHalf, position.y + (double)entity.field_70131_O, position.z + widthHalf);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static AxisAlignedBB getBB(Entity entity) {
        return ForgeEntity.getBB(entity, ForgeEntity.getCurPosition(entity));
    }

    public AxisAlignedBB getBB(Vect3d position) {
        return ForgeEntity.getBB(this, position);
    }

    public AxisAlignedBB getBB() {
        return ForgeEntity.getBB(this, this.getCurPosition());
    }

    public void updateBB() {
        ForgeEntity.updateBB(this);
    }

    public static void stopMoving(Entity entity) {
        if (entity != null) {
            ForgeEntity.setMotion(entity, Vect3d.ZERO);
        }
    }

    public void stopMoving() {
        ForgeEntity.stopMoving(this);
    }

    public static boolean isUnderRain(Entity entity) {
        BlockPos pos = ForgeEntity.getPositionTop(entity);
        return ForgeBlock.isUnderRain(entity.field_70170_p, pos);
    }

    public static boolean isUnderOpenSky(Entity entity) {
        BlockPos pos = ForgeEntity.getPositionTop(entity);
        return ForgeBlock.isUnderOpenSky(entity.field_70170_p, pos);
    }

    public static boolean isServerSide(Entity entity) {
        if (entity != null) {
            return ForgeWorld.isServerSide(entity.field_70170_p);
        }
        return false;
    }

    public boolean isServerSide() {
        return ForgeEntity.isServerSide(this);
    }

    public static boolean isClientSide(Entity entity) {
        if (entity != null) {
            return ForgeWorld.isClientSide(entity.field_70170_p);
        }
        return false;
    }

    public boolean isClientSide() {
        return ForgeEntity.isClientSide(this);
    }

    public List<Entity> getEntitiesWithinAABB(AxisAlignedBB aaBB) {
        if (this.field_70170_p != null) {
            return new ArrayList<Entity>(this.field_70170_p.func_72839_b((Entity)this, aaBB));
        }
        return Collections.emptyList();
    }

    public List<Entity> getCollidedEntitiesIfMove(Vect3d motion) {
        List<Entity> collidedEntities = this.getEntitiesWithinAABB(this.getBB(this.getNextPosition()));
        collidedEntities.remove((Object)this);
        return collidedEntities;
    }

    public static void setBB(Entity entity, Vect3d minPoint, Vect3d maxPoint) {
        if (entity != null && minPoint != null && maxPoint != null) {
            entity.func_174826_a(new AxisAlignedBB(minPoint.x, minPoint.y, minPoint.z, maxPoint.x, maxPoint.y, maxPoint.z));
        }
    }

    public void setBB(Vect3d minPoint, Vect3d maxPoint) {
        ForgeEntity.setBB(this, minPoint, maxPoint);
    }

    public static boolean hasSwingingPlayerPassenger(Entity entity) {
        if (entity != null) {
            for (Entity passenger : entity.func_184188_bt()) {
                if (!(passenger instanceof EntityPlayer) || !((EntityPlayer)passenger).field_82175_bq) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSwingingPlayerPassenger() {
        return ForgeEntity.hasSwingingPlayerPassenger(this);
    }

    public static boolean hasStack(Entity entity, ItemStack stack) {
        if (entity instanceof EntityItem) {
            return ((EntityItem)entity).func_92059_d().equals(stack);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            return player.field_71071_by.field_70462_a.contains((Object)stack) || player.field_71071_by.field_184439_c.contains((Object)stack) || player.field_71071_by.field_70460_b.contains((Object)stack);
        }
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            for (ItemStack equipedStack : Iterables.concat((Iterable)living.func_184214_aD(), (Iterable)living.func_184193_aE())) {
                if (!equipedStack.equals(stack)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static RayTraceResult rayTraceBlockBeingLookedAt(Entity entity, float partialTicks, float maxDistance) {
        World world = entity.func_130014_f_();
        Vec3d vecEyes = entity.func_174824_e(partialTicks);
        Vec3d vecLook = entity.func_70676_i(partialTicks).func_186678_a((double)maxDistance);
        Vec3d vecTarget = vecEyes.func_178787_e(vecLook);
        return world.func_147447_a(vecEyes, vecTarget, true, false, true);
    }

    public static Iterable<ItemStack> getEquipmentOn(Entity entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : entity.func_184193_aE()) {
            if (stack.func_190926_b()) continue;
            list.add(stack);
        }
        if (entity instanceof EntityPlayer && Loader.isModLoaded((String)"baubles")) {
            IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity));
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (stack.func_190926_b()) continue;
                list.add(stack);
            }
        }
        return list;
    }
}

