/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.init;

import lykrast.defiledlands.common.util.Config;
import lykrast.defiledlands.common.world.biome.BiomeDefiled;
import lykrast.defiledlands.common.world.biome.BiomeDesertDefiled;
import lykrast.defiledlands.common.world.biome.BiomeForestTenebra;
import lykrast.defiledlands.common.world.biome.BiomeForestVilespine;
import lykrast.defiledlands.common.world.biome.BiomeHillsDefiled;
import lykrast.defiledlands.common.world.biome.BiomeIcePlainsDefiled;
import lykrast.defiledlands.common.world.biome.BiomePlainsDefiled;
import lykrast.defiledlands.common.world.biome.BiomeSwampDefiled;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ModBiomes {
    public static BiomeDefiled desertDefiled = new BiomeDesertDefiled();
    public static BiomeDefiled plainsDefiled = new BiomePlainsDefiled();
    public static BiomeDefiled forestTenebra = new BiomeForestTenebra();
    public static BiomeDefiled forestVilespine = new BiomeForestVilespine();
    public static BiomeDefiled hillsDefiled = new BiomeHillsDefiled();
    public static BiomeDefiled swampDefiled = new BiomeSwampDefiled();
    public static BiomeDefiled icePlainsDefiled = new BiomeIcePlainsDefiled();

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        ModBiomes.register(event, desertDefiled, BiomeManager.BiomeType.DESERT, "desert_defiled", Config.weightDesertDefiled, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
        ModBiomes.register(event, plainsDefiled, BiomeManager.BiomeType.WARM, "plains_defiled", Config.weightPlainsDefiled, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.PLAINS);
        ModBiomes.register(event, forestTenebra, BiomeManager.BiomeType.WARM, "forest_tenebra", Config.weightForestTenebra, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.FOREST);
        ModBiomes.register(event, forestVilespine, BiomeManager.BiomeType.WARM, "forest_vilespine", Config.weightForestVilespine, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.FOREST);
        ModBiomes.register(event, hillsDefiled, BiomeManager.BiomeType.COOL, "hills_defiled", Config.weightHillsDefiled, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS);
        ModBiomes.register(event, swampDefiled, BiomeManager.BiomeType.WARM, "swamp_defiled", Config.weightSwampDefiled, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.register(event, icePlainsDefiled, BiomeManager.BiomeType.ICY, "ice_plains_defiled", Config.weightIcePlainsDefiled, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND);
    }

    public static void register(RegistryEvent.Register<Biome> event, Biome biome, BiomeManager.BiomeType type, String name, int weight, BiomeDictionary.Type ... biomeDictTypes) {
        biome.setRegistryName(new ResourceLocation("defiledlands", name));
        event.getRegistry().register((IForgeRegistryEntry)biome);
        for (BiomeDictionary.Type biomeDictType : biomeDictTypes) {
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{biomeDictType});
        }
        BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
    }

    public static void cleanSpawnLists() {
        desertDefiled.cleanSpawnLists();
        plainsDefiled.cleanSpawnLists();
        forestTenebra.cleanSpawnLists();
        forestVilespine.cleanSpawnLists();
        hillsDefiled.cleanSpawnLists();
        swampDefiled.cleanSpawnLists();
        icePlainsDefiled.cleanSpawnLists();
    }
}

