/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.config;

import ichttt.mods.firstaid.common.config.UniqueProperty;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ConfigEntry<T extends Annotation> {
    @Nonnull
    public final Field field;
    @Nullable
    private final Object fieldAccessor;
    private final boolean revert;
    @Nonnull
    public final UniqueProperty property;
    @Nonnull
    public final T annotation;
    private boolean hasRemoteData = false;
    @Nullable
    private ByteBuf originalState;

    public ConfigEntry(@Nonnull Field f, @Nullable Object fieldAccessor, @Nonnull T annotation, boolean revertOnSave, @Nonnull UniqueProperty property) {
        this.field = f;
        this.fieldAccessor = fieldAccessor;
        this.revert = revertOnSave;
        this.property = property;
        this.annotation = annotation;
        if (revertOnSave) {
            ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer();
            try {
                Object originalState = f.get(fieldAccessor);
                this.writeToBuf(buffer);
                this.readFromBuf(buffer);
                if (!originalState.equals(f.get(fieldAccessor))) {
                    throw new RuntimeException("Error while writing and reading: Values do not match!");
                }
                buffer.release();
            }
            catch (IllegalAccessException e) {
                buffer.release();
                throw new RuntimeException("Failed to access field " + f, e);
            }
            finally {
                this.hasRemoteData = false;
            }
            this.originalState = ByteBufAllocator.DEFAULT.buffer();
            this.writeToBuf(this.originalState);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.originalState != null && this.originalState.refCnt() > 0) {
            this.originalState.release(this.originalState.refCnt());
        }
    }

    public boolean hasRemoteData() {
        return this.hasRemoteData;
    }

    public void revert() {
        if (this.revert && this.hasRemoteData) {
            this.readFromBuf(Objects.requireNonNull(this.originalState).copy());
            this.hasRemoteData = false;
        }
    }

    public void updateOrigState() {
        if (this.revert) {
            Objects.requireNonNull(this.originalState).release();
            this.originalState = ByteBufAllocator.DEFAULT.buffer();
            this.writeToBuf(this.originalState);
        }
    }

    public void writeToBuf(ByteBuf buf) {
        try {
            ConfigEntry.writeToByteBuf(this.field, this.fieldAccessor, buf);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to read config entry " + this.field + " for write to ByteBuffer!", e);
        }
    }

    public void readFromBuf(ByteBuf buf) {
        try {
            this.hasRemoteData = true;
            ConfigEntry.readFromByteBuf(this.field, this.fieldAccessor, buf);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to write config entry " + this.field + " from ByteBuffer!", e);
        }
    }

    private static boolean noSync(Field f, boolean isStatic) {
        if (!Modifier.isPublic(f.getModifiers())) {
            return true;
        }
        if (Modifier.isStatic(f.getModifiers()) != isStatic) {
            return true;
        }
        return f.isAnnotationPresent(Config.Ignore.class);
    }

    private static void readFromByteBuf(Field f, Object fieldAccessor, ByteBuf buf) throws IllegalAccessException {
        if (ConfigEntry.noSync(f, fieldAccessor == null)) {
            return;
        }
        Class<?> type = f.getType();
        if (type == Boolean.TYPE || type == Boolean.class) {
            f.setBoolean(fieldAccessor, buf.readBoolean());
        } else if (type == Float.TYPE || type == Float.class) {
            f.setFloat(fieldAccessor, buf.readFloat());
        } else if (type == Double.TYPE || type == Double.class) {
            f.setDouble(fieldAccessor, buf.readDouble());
        } else if (type == Byte.TYPE || type == Byte.class) {
            f.setByte(fieldAccessor, buf.readByte());
        } else if (type == Character.TYPE || type == Character.class) {
            f.setChar(fieldAccessor, buf.readChar());
        } else if (type == Short.TYPE || type == Short.class) {
            f.setShort(fieldAccessor, buf.readShort());
        } else if (type == Integer.TYPE || type == Integer.class) {
            f.setInt(fieldAccessor, buf.readInt());
        } else if (type == String.class) {
            f.set(fieldAccessor, ByteBufUtils.readUTF8String((ByteBuf)buf));
        } else {
            if (type == boolean[].class || type == Boolean[].class) {
                throw new UnsupportedOperationException("Cannot read from buf: Class not implemented for sync: " + type);
            }
            if (type == float[].class || type == Float[].class) {
                throw new UnsupportedOperationException("Cannot read from buf: Class not implemented for sync: " + type);
            }
            if (type == double[].class || type == Double[].class) {
                throw new UnsupportedOperationException("Cannot read from buf: Class not implemented for sync: " + type);
            }
            if (type == byte[].class || type == Byte[].class) {
                throw new UnsupportedOperationException("Cannot read from buf: Class not implemented for sync: " + type);
            }
            if (type == char[].class || type == Character[].class) {
                throw new UnsupportedOperationException("Cannot read from buf: Class not implemented for sync: " + type);
            }
            if (type == short[].class || type == Short[].class) {
                throw new UnsupportedOperationException("Cannot read from buf: Class not implemented for sync: " + type);
            }
            if (type == int[].class || type == Integer[].class) {
                int len = buf.readByte();
                int[] arr = new int[len];
                for (int i = 0; i < len; ++i) {
                    arr[i] = buf.readInt();
                }
                f.set(fieldAccessor, arr);
            } else if (type == String[].class) {
                int len = buf.readByte();
                String[] arr = new String[len];
                for (int i = 0; i < len; ++i) {
                    arr[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
                }
                f.set(fieldAccessor, arr);
            } else if (type.getSuperclass() == Object.class) {
                Object newInstance = f.get(fieldAccessor);
                for (Field newField : newInstance.getClass().getDeclaredFields()) {
                    ConfigEntry.readFromByteBuf(newField, newInstance, buf);
                }
            }
        }
    }

    private static void writeToByteBuf(Field f, Object fieldAccessor, ByteBuf buf) throws IllegalAccessException {
        block11: {
            Class<?> type;
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                block10: {
                                                    if (ConfigEntry.noSync(f, fieldAccessor == null)) {
                                                        return;
                                                    }
                                                    type = f.getType();
                                                    if (type != Boolean.TYPE && type != Boolean.class) break block10;
                                                    buf.writeBoolean(f.getBoolean(fieldAccessor));
                                                    break block11;
                                                }
                                                if (type != Float.TYPE && type != Float.class) break block12;
                                                buf.writeFloat(f.getFloat(fieldAccessor));
                                                break block11;
                                            }
                                            if (type != Double.TYPE && type != Double.class) break block13;
                                            buf.writeDouble(f.getDouble(fieldAccessor));
                                            break block11;
                                        }
                                        if (type != Byte.TYPE && type != Byte.class) break block14;
                                        buf.writeByte((int)f.getByte(fieldAccessor));
                                        break block11;
                                    }
                                    if (type != Character.TYPE && type != Character.class) break block15;
                                    buf.writeChar((int)f.getChar(fieldAccessor));
                                    break block11;
                                }
                                if (type != Short.TYPE && type != Short.class) break block16;
                                buf.writeChar((int)f.getShort(fieldAccessor));
                                break block11;
                            }
                            if (type != Integer.TYPE && type != Integer.class) break block17;
                            buf.writeInt(f.getInt(fieldAccessor));
                            break block11;
                        }
                        if (type != String.class) break block18;
                        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)f.get(fieldAccessor)));
                        break block11;
                    }
                    if (type == boolean[].class || type == Boolean[].class) {
                        throw new UnsupportedOperationException("Cannot write to buf: Class not implemented for sync: " + type);
                    }
                    if (type == float[].class || type == Float[].class) {
                        throw new UnsupportedOperationException("Cannot write to buf: Class not implemented for sync: " + type);
                    }
                    if (type == double[].class || type == Double[].class) {
                        throw new UnsupportedOperationException("Cannot write to buf: Class not implemented for sync: " + type);
                    }
                    if (type == byte[].class || type == Byte[].class) {
                        throw new UnsupportedOperationException("Cannot write to buf: Class not implemented for sync: " + type);
                    }
                    if (type == char[].class || type == Character[].class) {
                        throw new UnsupportedOperationException("Cannot write to buf: Class not implemented for sync: " + type);
                    }
                    if (type == short[].class || type == Short[].class) {
                        throw new UnsupportedOperationException("Cannot write to buf: Class not implemented for sync: " + type);
                    }
                    if (type != int[].class && type != Integer[].class) break block19;
                    int[] value = (int[])f.get(fieldAccessor);
                    buf.writeByte((int)ConfigEntry.checkedCast(value.length));
                    for (int i : value) {
                        buf.writeInt(i);
                    }
                    break block11;
                }
                if (type != String[].class) break block20;
                String[] value = (String[])f.get(fieldAccessor);
                buf.writeByte((int)ConfigEntry.checkedCast(value.length));
                for (String s : value) {
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
                }
                break block11;
            }
            if (type.getSuperclass() != Object.class) break block11;
            Object newInstance = f.get(fieldAccessor);
            for (Field newField : newInstance.getClass().getDeclaredFields()) {
                ConfigEntry.writeToByteBuf(newField, newInstance, buf);
            }
        }
    }

    private static byte checkedCast(int val) {
        if (val > 127) {
            throw new RuntimeException(val + " is too large!");
        }
        return (byte)val;
    }
}

