/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import com.google.common.math.DoubleMath;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.common.util.CommonUtils;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.Loader;

public class ArmorUtils {
    public static final boolean QUALITY_TOOLS_PRESENT = Loader.isModLoaded((String)"qualitytools");

    public static double getArmor(ItemStack stack, EntityEquipmentSlot slot, boolean includeQualityTools) {
        double attributeVal = ArmorUtils.getValueFromAttributes(SharedMonsterAttributes.field_188791_g, slot, stack);
        if (includeQualityTools) {
            attributeVal += ArmorUtils.getValueFromQualityTools(SharedMonsterAttributes.field_188791_g, stack);
        }
        return attributeVal;
    }

    public static double getArmorToughness(ItemStack stack, EntityEquipmentSlot slot, boolean includeQualityTools) {
        double attributeVal = ArmorUtils.getValueFromAttributes(SharedMonsterAttributes.field_189429_h, slot, stack);
        if (includeQualityTools) {
            attributeVal += ArmorUtils.getValueFromQualityTools(SharedMonsterAttributes.field_189429_h, stack);
        }
        return attributeVal;
    }

    public static double applyArmorModifier(EntityEquipmentSlot slot, double rawArmor) {
        if (rawArmor <= 0.0) {
            return 0.0;
        }
        rawArmor *= ArmorUtils.getArmorMultiplier(slot);
        return rawArmor += ArmorUtils.getArmorOffset(slot);
    }

    public static double applyToughnessModifier(EntityEquipmentSlot slot, double rawToughness) {
        if (rawToughness <= 0.0) {
            return 0.0;
        }
        rawToughness *= ArmorUtils.getToughnessMultiplier(slot);
        return rawToughness += ArmorUtils.getToughnessOffset(slot);
    }

    public static double getArmorMultiplier(EntityEquipmentSlot slot) {
        FirstAidConfig.LocationalArmor.Armor config = FirstAidConfig.locationalArmor.armor;
        switch (slot) {
            case HEAD: {
                return config.headArmorMultiplier;
            }
            case CHEST: {
                return config.chestArmorMultiplier;
            }
            case LEGS: {
                return config.legsArmorMultiplier;
            }
            case FEET: {
                return config.feetArmorMultiplier;
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    private static double getArmorOffset(EntityEquipmentSlot slot) {
        FirstAidConfig.LocationalArmor.Armor config = FirstAidConfig.locationalArmor.armor;
        switch (slot) {
            case HEAD: {
                return config.headArmorOffset;
            }
            case CHEST: {
                return config.chestArmorOffset;
            }
            case LEGS: {
                return config.legsArmorOffset;
            }
            case FEET: {
                return config.feetArmorOffset;
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    public static double getToughnessMultiplier(EntityEquipmentSlot slot) {
        FirstAidConfig.LocationalArmor.Toughness config = FirstAidConfig.locationalArmor.toughness;
        switch (slot) {
            case HEAD: {
                return config.headToughnessMultiplier;
            }
            case CHEST: {
                return config.chestToughnessMultiplier;
            }
            case LEGS: {
                return config.legsToughnessMultiplier;
            }
            case FEET: {
                return config.feetToughnessMultiplier;
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    private static double getToughnessOffset(EntityEquipmentSlot slot) {
        FirstAidConfig.LocationalArmor.Toughness config = FirstAidConfig.locationalArmor.toughness;
        switch (slot) {
            case HEAD: {
                return config.headToughnessOffset;
            }
            case CHEST: {
                return config.chestToughnessOffset;
            }
            case LEGS: {
                return config.legsToughnessOffset;
            }
            case FEET: {
                return config.feetToughnessOffset;
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    private static double getValueFromAttributes(IAttribute attribute, EntityEquipmentSlot slot, ItemStack stack) {
        return stack.func_77973_b().getAttributeModifiers(slot, stack).get((Object)attribute.func_111108_a()).stream().mapToDouble(AttributeModifier::func_111164_d).sum();
    }

    public static double getValueFromQualityTools(IAttribute attribute, ItemStack stack) {
        NBTTagCompound quality;
        NBTTagCompound tagCompound;
        double ret = 0.0;
        if (QUALITY_TOOLS_PRESENT && (tagCompound = stack.func_77978_p()) != null && tagCompound.func_150297_b("Quality", 10) && (quality = tagCompound.func_74775_l("Quality")).func_150297_b("AttributeModifiers", 9)) {
            NBTTagList attributeModifiers = quality.func_150295_c("AttributeModifiers", 10);
            for (NBTBase attributeModifierRaw : attributeModifiers) {
                NBTTagCompound attributeModifier;
                String attributeName;
                if (!(attributeModifierRaw instanceof NBTTagCompound) || !(attributeName = (attributeModifier = (NBTTagCompound)attributeModifierRaw).func_74779_i("AttributeName")).equalsIgnoreCase(attribute.func_111108_a())) continue;
                ret += attributeModifier.func_74769_h("Amount");
            }
        }
        return ret;
    }

    private static double getGlobalRestAttribute(EntityPlayer player, IAttribute attribute) {
        double sumOfAllAttributes = 0.0;
        for (EntityEquipmentSlot slot : CommonUtils.ARMOR_SLOTS) {
            ItemStack otherStack = player.func_184582_a(slot);
            sumOfAllAttributes += ArmorUtils.getValueFromAttributes(attribute, slot, otherStack);
            sumOfAllAttributes += ArmorUtils.getValueFromQualityTools(attribute, otherStack);
        }
        double all = player.func_110148_a(attribute).func_111126_e();
        if (!DoubleMath.fuzzyEquals((double)sumOfAllAttributes, (double)all, (double)0.001)) {
            double diff = all - sumOfAllAttributes;
            if (FirstAidConfig.debug) {
                FirstAid.LOGGER.info("Attribute value for {} does not match sum! Diff is {}, distributing to all!", (Object)attribute.func_111108_a(), (Object)diff);
            }
            return diff;
        }
        return 0.0;
    }

    public static float applyArmor(@Nonnull EntityPlayer entity, @Nonnull ItemStack itemStack, @Nonnull DamageSource source, double damage, @Nonnull EntityEquipmentSlot slot) {
        ISpecialArmor armor;
        NonNullList inventory = entity.field_71071_by.field_70460_b;
        double totalArmor = 0.0;
        double totalToughness = 0.0;
        Item item = itemStack.func_77973_b();
        ISpecialArmor.ArmorProperties prop = null;
        boolean unblockable = source.func_76363_c();
        if (unblockable && item instanceof ISpecialArmor) {
            unblockable = ((ISpecialArmor)item).handleUnblockableDamage((EntityLivingBase)entity, itemStack, source, damage, slot.func_188454_b());
        }
        if (unblockable) {
            return (float)damage;
        }
        if (item instanceof ISpecialArmor) {
            armor = (ISpecialArmor)item;
            prop = armor.getProperties((EntityLivingBase)entity, itemStack, source, damage, slot.func_188454_b()).copy();
            totalArmor += prop.Armor;
            totalToughness += prop.Toughness;
        } else if (item instanceof ItemArmor) {
            armor = (ItemArmor)item;
            prop = new ISpecialArmor.ArmorProperties(0, 0.0, Integer.MAX_VALUE);
            prop.Armor = armor.field_77879_b;
            prop.Toughness = armor.field_189415_e;
        }
        if (item instanceof ItemArmor) {
            totalArmor += ArmorUtils.getArmor(itemStack, slot, true);
            totalToughness += ArmorUtils.getArmorToughness(itemStack, slot, true);
        }
        if (prop != null) {
            totalArmor = ArmorUtils.applyArmorModifier(slot, totalArmor);
            totalToughness = ArmorUtils.applyToughnessModifier(slot, totalToughness);
            prop.Slot = slot.func_188454_b();
            double ratio = prop.AbsorbRatio * ArmorUtils.getArmorMultiplier(slot);
            double absorb = damage * ratio;
            if (absorb > 0.0) {
                ItemStack stack = (ItemStack)inventory.get(prop.Slot);
                int itemDamage = (int)Math.max(1.0, absorb);
                if (stack.func_77973_b() instanceof ISpecialArmor) {
                    ((ISpecialArmor)stack.func_77973_b()).damageArmor((EntityLivingBase)entity, stack, source, itemDamage, prop.Slot);
                } else {
                    stack.func_77972_a(itemDamage, (EntityLivingBase)entity);
                }
            }
            damage -= damage * ratio;
        }
        totalArmor += ArmorUtils.getGlobalRestAttribute(entity, SharedMonsterAttributes.field_188791_g);
        totalToughness += ArmorUtils.getGlobalRestAttribute(entity, SharedMonsterAttributes.field_189429_h);
        if (damage > 0.0 && (totalArmor > 0.0 || totalToughness > 0.0)) {
            double armorDamage = Math.max(1.0, damage);
            if (item instanceof ItemArmor) {
                itemStack.func_77972_a((int)armorDamage, (EntityLivingBase)entity);
            }
            damage = CombatRules.func_189427_a((float)((float)damage), (float)((float)totalArmor), (float)((float)totalToughness));
        }
        return (float)damage;
    }

    public static float applyGlobalPotionModifiers(EntityPlayer player, DamageSource source, float damage) {
        if (source.func_151517_h()) {
            return damage;
        }
        if (player.func_70644_a(MobEffects.field_76429_m) && source != DamageSource.field_76380_i) {
            int i = (player.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * FirstAidConfig.externalHealing.resistanceReductionPercentPerLevel;
            int j = 100 - i;
            float f = damage * (float)j;
            damage = f / 100.0f;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        return damage;
    }

    public static float applyEnchantmentModifiers(EntityPlayer player, EntityEquipmentSlot slot, DamageSource source, float damage) {
        int k;
        if (source.func_151517_h()) {
            return damage;
        }
        if (FirstAidConfig.enchantmentHandling.armorEnchantmentMode == FirstAidConfig.EnchantmentHandling.ArmorEnchantmentMode.LOCAL_ENCHANTMENTS) {
            ItemStack itemStackFromSlot = player.func_184582_a(slot);
            k = ArmorUtils.calculateEnchantmentModifierLocal(itemStackFromSlot, source);
        } else if (FirstAidConfig.enchantmentHandling.armorEnchantmentMode == FirstAidConfig.EnchantmentHandling.ArmorEnchantmentMode.GLOBAL_ENCHANTMENTS) {
            k = EnchantmentHelper.func_77508_a((Iterable)player.func_184193_aE(), (DamageSource)source);
        } else {
            throw new RuntimeException("What dark magic is " + (Object)((Object)FirstAidConfig.enchantmentHandling.armorEnchantmentMode));
        }
        if (k > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }

    private static int calculateEnchantmentModifierLocal(ItemStack stack, DamageSource source) {
        int ret = 0;
        if (!stack.func_190926_b()) {
            NBTTagList nbttaglist = stack.func_77986_q();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                short j = nbttaglist.func_150305_b(i).func_74765_d("id");
                short k = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                if (Enchantment.func_185262_c((int)j) == null) continue;
                Enchantment enchantment = Enchantment.func_185262_c((int)j);
                int val = enchantment.func_77318_a((int)k, source);
                String[] resourceLocation = FirstAidConfig.enchantmentHandling.overrideEntries.resourceLocation;
                int[] multiplierOverride = FirstAidConfig.enchantmentHandling.overrideEntries.multiplierOverride;
                String enchantRlAsString = enchantment.getRegistryName().toString();
                int multiplier = FirstAidConfig.enchantmentHandling.enchantmentMultiplier;
                if (FirstAidConfig.debug) {
                    FirstAid.LOGGER.info("Searching for enchantment multiplier override for {}, base is {}", (Object)enchantRlAsString, (Object)multiplier);
                }
                for (int l = 0; l < Math.min(resourceLocation.length, multiplierOverride.length); ++l) {
                    String s = resourceLocation[l];
                    if (!s.equals(enchantRlAsString)) continue;
                    multiplier = multiplierOverride[l];
                    if (!FirstAidConfig.debug) break;
                    FirstAid.LOGGER.info("Found enchantment multiplier override for {}, new value is {}", (Object)enchantRlAsString, (Object)multiplier);
                    break;
                }
                ret += val * multiplier;
            }
        }
        return ret;
    }

    static {
        if (QUALITY_TOOLS_PRESENT) {
            FirstAid.LOGGER.info("Quality Tools mod present. Enabling compat...");
        }
    }
}

