/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tschipp.callablehorses.common.capabilities.storedhorse.HorseProvider;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.helper.HorseHelper;

public class HorseCapSyncPacket
implements IMessage,
IMessageHandler<HorseCapSyncPacket, IMessage> {
    private int entityID = 0;
    private NBTTagCompound horseNBT = null;

    public HorseCapSyncPacket() {
    }

    public HorseCapSyncPacket(int entityID, IStoredHorse horse) {
        this.entityID = entityID;
        this.horseNBT = (NBTTagCompound)HorseProvider.HORSE_CAPABILITY.getStorage().writeNBT(HorseProvider.HORSE_CAPABILITY, (Object)horse, null);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.horseNBT = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.horseNBT);
    }

    public IMessage onMessage(final HorseCapSyncPacket message, MessageContext ctx) {
        Minecraft mainThread = Minecraft.func_71410_x();
        mainThread.func_152344_a(new Runnable(){
            World world;
            {
                this.world = Minecraft.func_71410_x().field_71441_e;
            }

            @Override
            public void run() {
                Entity e = this.world.func_73045_a(message.entityID);
                if (e != null) {
                    IStoredHorse horse = HorseHelper.getHorseCap(e);
                    HorseProvider.HORSE_CAPABILITY.getStorage().readNBT(HorseProvider.HORSE_CAPABILITY, (Object)horse, null, (NBTBase)message.horseNBT);
                }
            }
        });
        return null;
    }
}

