/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.asm.util;

import com.charles445.rltweaker.asm.helper.ASMHelper;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class TransformUtil {
    @Nullable
    public static FieldInsnNode findNextFieldWithOpcodeAndName(AbstractInsnNode anchor, int opcode, String ... names) {
        AbstractInsnNode search = ASMHelper.findNextInstructionWithOpcode(anchor, opcode);
        while (search != null) {
            if (search.getOpcode() == opcode) {
                for (String name : names) {
                    if (!name.equals(((FieldInsnNode)search).name)) continue;
                    return (FieldInsnNode)search;
                }
            }
            search = ASMHelper.findNextInstructionWithOpcode(search, opcode);
        }
        return null;
    }

    @Nullable
    public static FieldInsnNode findPreviousFieldWithOpcodeAndName(AbstractInsnNode anchor, int opcode, String ... names) {
        AbstractInsnNode search = ASMHelper.findPreviousInstructionWithOpcode(anchor, opcode);
        while (search != null) {
            if (search.getOpcode() == opcode) {
                for (String name : names) {
                    if (!name.equals(((FieldInsnNode)search).name)) continue;
                    return (FieldInsnNode)search;
                }
            }
            search = ASMHelper.findPreviousInstructionWithOpcode(search, opcode);
        }
        return null;
    }

    @Nullable
    public static IntInsnNode findNextIntInsnNodeWithValue(AbstractInsnNode anchor, int value) {
        AbstractInsnNode search = ASMHelper.findNextInstruction(anchor);
        while (search != null) {
            if (search.getType() == 1 && value == ((IntInsnNode)search).operand) {
                return (IntInsnNode)search;
            }
            search = ASMHelper.findNextInstruction(search);
        }
        return null;
    }

    @Nullable
    public static IntInsnNode findPreviousIntInsnNodeWithValue(AbstractInsnNode anchor, int value) {
        AbstractInsnNode search = ASMHelper.findPreviousInstruction(anchor);
        while (search != null) {
            if (search.getType() == 1 && value == ((IntInsnNode)search).operand) {
                return (IntInsnNode)search;
            }
            search = ASMHelper.findPreviousInstruction(search);
        }
        return null;
    }

    @Nullable
    public static MethodInsnNode findNextCallWithOpcodeAndName(AbstractInsnNode anchor, int opcode, String ... names) {
        AbstractInsnNode search = ASMHelper.findNextInstructionWithOpcode(anchor, opcode);
        while (search != null) {
            if (search.getOpcode() == opcode) {
                for (String name : names) {
                    if (!name.equals(((MethodInsnNode)search).name)) continue;
                    return (MethodInsnNode)search;
                }
            }
            search = ASMHelper.findNextInstructionWithOpcode(search, opcode);
        }
        return null;
    }

    @Nullable
    public static MethodInsnNode findPreviousCallWithOpcodeAndName(AbstractInsnNode anchor, int opcode, String ... names) {
        AbstractInsnNode search = ASMHelper.findPreviousInstructionWithOpcode(anchor, opcode);
        while (search != null) {
            if (search.getOpcode() == opcode) {
                for (String name : names) {
                    if (!name.equals(((MethodInsnNode)search).name)) continue;
                    return (MethodInsnNode)search;
                }
            }
            search = ASMHelper.findPreviousInstructionWithOpcode(search, opcode);
        }
        return null;
    }

    public static void insertBeforeFirst(MethodNode mNode, InsnList insnList) {
        mNode.instructions.insertBefore(ASMHelper.findFirstInstruction(mNode), insnList);
    }

    @Nullable
    public static LocalVariableNode findLocalVariableWithDesc(MethodNode methodNode, String desc) {
        int count = 0;
        LocalVariableNode result = null;
        for (LocalVariableNode lvNode : methodNode.localVariables) {
            if (!lvNode.desc.equals(desc)) continue;
            result = lvNode;
            ++count;
        }
        return result;
    }

    @Nullable
    public static LocalVariableNode findLocalVariableWithName(MethodNode methodNode, String name) {
        int count = 0;
        LocalVariableNode result = null;
        for (LocalVariableNode lvNode : methodNode.localVariables) {
            if (!lvNode.name.equals(name)) continue;
            result = lvNode;
            ++count;
        }
        return result;
    }

    @Nullable
    public static LocalVariableNode createNewLocalVariable(MethodNode methodNode, String name, String desc) {
        int index = 0;
        for (LocalVariableNode lvn : methodNode.localVariables) {
            if (lvn.index < index) continue;
            index = lvn.index + 1;
        }
        LabelNode l1 = null;
        LabelNode l2 = null;
        for (AbstractInsnNode anchor = methodNode.instructions.getFirst(); anchor != null; anchor = anchor.getNext()) {
            if (!(anchor instanceof LabelNode)) continue;
            if (l1 == null) {
                l1 = (LabelNode)anchor;
            }
            l2 = (LabelNode)anchor;
        }
        if (l1 == null | l2 == null) {
            return null;
        }
        return new LocalVariableNode(name, desc, null, l1, l2, index);
    }

    @Nullable
    public static AbstractInsnNode gotoLabel(MethodNode methodNode, LabelNode label) {
        return ASMHelper.find(methodNode.instructions.getFirst(), (AbstractInsnNode)label);
    }
}

