/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.config;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.config.init.JsonConfigLessCollisions;
import com.charles445.rltweaker.config.json.JsonDoubleBlockState;
import com.charles445.rltweaker.config.json.JsonFileName;
import com.charles445.rltweaker.config.json.JsonTypeToken;
import com.charles445.rltweaker.handler.ReskillableHandler;
import com.charles445.rltweaker.util.CollisionUtil;
import com.charles445.rltweaker.util.ErrorUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FileUtils;

public class JsonConfig {
    public static List<String> jsonErrors = new ArrayList<String>();
    public static Map<String, Double> lessCollisions = new HashMap<String, Double>();
    public static Map<String, List<JsonDoubleBlockState>> reskillableTransmutation = new HashMap<String, List<JsonDoubleBlockState>>();

    public static void init() {
        if (ModConfig.patches.lessCollisions) {
            lessCollisions.putAll(JsonConfigLessCollisions.getDefaults());
            Map<String, Double> lcJson = JsonConfig.processJson(JsonFileName.lessCollisions, lessCollisions, true);
            if (lcJson != null) {
                try {
                    lessCollisions.putAll(lcJson);
                    JsonConfig.manuallyWriteToJson(JsonFileName.lessCollisions, lessCollisions);
                }
                catch (Exception e) {
                    RLTweaker.logger.error("Failed to merge write lessCollisions!");
                    ErrorUtil.logSilent("JSON Merge Write LessCollisions");
                }
            }
            if (lessCollisions == null) {
                lessCollisions = new HashMap<String, Double>();
            }
            CollisionUtil.instance.addToStringReference(lessCollisions);
        }
        if (Loader.isModLoaded((String)"reskillable") && ModConfig.server.reskillable.enabled && ModConfig.server.reskillable.customTransmutation) {
            Object reskillableHandler;
            reskillableTransmutation.clear();
            reskillableTransmutation.put("minecraft:stick", Arrays.asList(JsonDoubleBlockState.AIR));
            reskillableTransmutation = JsonConfig.processJson(JsonFileName.reskillableTransmutation, reskillableTransmutation, false);
            if (reskillableTransmutation != null && (reskillableHandler = RLTweaker.handlers.get("reskillable")) instanceof ReskillableHandler) {
                ((ReskillableHandler)reskillableHandler).registerTransmutations();
            }
        }
    }

    @Nullable
    public static <T> T processJson(JsonFileName jfn, T container, boolean forMerging) {
        try {
            return JsonConfig.processUncaughtJson(jfn, container, forMerging);
        }
        catch (Exception e) {
            RLTweaker.logger.error("Error managing JSON File: " + jfn.get(), (Throwable)e);
            jsonErrors.add("config/rltweaker/" + jfn.get() + " failed to load!");
            ErrorUtil.logSilent("JSON Error: " + jfn.get());
            if (forMerging) {
                return null;
            }
            return container;
        }
    }

    @Nullable
    public static <T> T processUncaughtJson(JsonFileName jfn, T container, boolean forMerging) throws Exception {
        String jsonFileName = jfn.get();
        Type type = JsonTypeToken.get(jfn);
        File jsonFile = new File(RLTweaker.jsonDirectory, jsonFileName);
        if (jsonFile.exists()) {
            Gson gson = JsonConfig.buildNewGson();
            return (T)gson.fromJson((Reader)new FileReader(jsonFile), type);
        }
        Gson gson = JsonConfig.buildNewGson();
        FileUtils.write((File)jsonFile, (CharSequence)gson.toJson(container, type), (String)null);
        if (forMerging) {
            return null;
        }
        return container;
    }

    private static <T> void manuallyWriteToJson(JsonFileName jfn, T container) throws Exception {
        String jsonFileName = jfn.get();
        Type type = JsonTypeToken.get(jfn);
        Gson gson = JsonConfig.buildNewGson();
        File jsonFile = new File(RLTweaker.jsonDirectory, jsonFileName);
        FileUtils.write((File)jsonFile, (CharSequence)gson.toJson(container, type), (String)null);
    }

    private static Gson buildNewGson() {
        return new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2, 8}).create();
    }
}

