/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.CarryOnReflect;
import com.charles445.rltweaker.reflect.QuarkReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import com.charles445.rltweaker.util.StackTraceUtil;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CarryOnHandler {
    boolean quarkLoaded;
    CarryOnReflect reflector;
    @Nullable
    QuarkReflect reflectorQuark;

    public CarryOnHandler() {
        block6: {
            this.quarkLoaded = false;
            try {
                this.reflector = new CarryOnReflect();
                this.quarkLoaded = Loader.isModLoaded((String)"quark");
                try {
                    if (this.quarkLoaded) {
                        this.reflectorQuark = new QuarkReflect();
                    }
                }
                catch (Exception e) {
                    RLTweaker.logger.error("Failed to setup Quark for Carryon");
                    ErrorUtil.logSilent("CarryOn Quark Reflector Initialization");
                }
                if (ModConfig.server.carryon.tileEntityDropSafetyCheck) {
                    CompatUtil.wrapSpecificHandler("COItemDropped", x$0 -> new COItemDropped((IEventListener)x$0), "tschipp.carryon.common.event.ItemEvents", "onItemDropped");
                }
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup CarryOnHandler!", (Throwable)e);
                ErrorUtil.logSilent("CarryOn Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block6;
                throw new RuntimeException(e);
            }
        }
    }

    @SubscribeEvent
    public void onPlaceEvent(BlockEvent.PlaceEvent event) {
        if (StackTraceUtil.stackTraceHasClassOfMethod("tschipp.carryon.common.item.ItemTile", "func_180614_a", "onItemUse")) {
            BlockSnapshot snapshot = event.getBlockSnapshot();
            ResourceLocation registry = snapshot.getRegistryName();
            World world = event.getWorld();
            EntityPlayer player = event.getPlayer();
            if (this.quarkLoaded && this.reflectorQuark != null && registry.func_110624_b().equals("quark")) {
                this.handlePlacedQuarkBlock(event, snapshot, registry, world, player);
            }
        }
    }

    public void handlePlacedQuarkBlock(BlockEvent.PlaceEvent event, BlockSnapshot snapshot, ResourceLocation registry, World world, EntityPlayer player) {
        Block block = snapshot.getReplacedBlock().func_177230_c();
        BlockPos pos = snapshot.getPos();
        if (ModConfig.server.carryon.quarkChestFix && this.reflectorQuark.isBlockCustomChest(block)) {
            try {
                NBTTagCompound data;
                Object type;
                NBTTagCompound compound;
                ItemStack stack = event.getItemInHand();
                if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("tileData") && (type = this.reflectorQuark.getChestTypeFromString((data = compound.func_74775_l("tileData")).func_74779_i("type"))) != null) {
                    int chestCount = 0;
                    chestCount += this.getChestAdjacentCount(block, type, world, pos.func_177978_c());
                    chestCount += this.getChestAdjacentCount(block, type, world, pos.func_177968_d());
                    chestCount += this.getChestAdjacentCount(block, type, world, pos.func_177974_f());
                    if ((chestCount += this.getChestAdjacentCount(block, type, world, pos.func_177976_e())) >= 1) {
                        event.setCanceled(true);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                ErrorUtil.logSilent("CarryOn Quark BlockCustomChest");
            }
        }
    }

    private int getChestAdjacentCount(Block block, Object type, World world, BlockPos adjacent) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.checkChestMatch(block, type, world, adjacent)) {
            return this.reflectorQuark.isDoubleChest(block, world, adjacent, type) ? 2 : 1;
        }
        return 0;
    }

    private boolean checkChestMatch(Block block, Object type, World world, BlockPos pos) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return world.func_180495_p(pos).func_177230_c() == block && this.reflectorQuark.getCustomChestType(block, (IBlockAccess)world, pos) == type;
    }

    public class COItemDropped {
        private IEventListener handler;

        public COItemDropped(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public void onItemDropped(EntityJoinWorldEvent event) {
            Vec3d relocate = this.itemDropRoutine(event);
            this.handler.invoke((Event)event);
            if (relocate != null) {
                event.getEntity().func_70107_b(relocate.field_72450_a, relocate.field_72448_b, relocate.field_72449_c);
            }
        }

        @Nullable
        public Vec3d itemDropRoutine(EntityJoinWorldEvent event) {
            if (!ModConfig.server.carryon.tileEntityDropSafetyCheck) {
                return null;
            }
            try {
                Block itemTileBlock;
                if (!(event.getEntity() instanceof EntityItem)) {
                    return null;
                }
                EntityItem entityItem = (EntityItem)event.getEntity();
                ItemStack stack = entityItem.func_92059_d();
                Item item = stack.func_77973_b();
                if (!CarryOnHandler.this.reflector.isItemTile(item)) {
                    return null;
                }
                if (!CarryOnHandler.this.reflector.hasTileData(stack)) {
                    return null;
                }
                Vec3d vec = entityItem.func_174791_d();
                BlockPos pos = entityItem.func_180425_c();
                World world = event.getWorld();
                if (this.isChangeable(world, pos, itemTileBlock = CarryOnHandler.this.reflector.getItemTileBlock(stack))) {
                    return null;
                }
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    BlockPos newPos = pos.func_177972_a(facing);
                    if (!this.trySetChangeable(world, newPos, itemTileBlock, entityItem)) continue;
                    RLTweaker.logger.debug("CarryOn tile intercepted for safety purposes... " + pos.toString());
                    return vec;
                }
                RLTweaker.logger.debug("CarryOn tile routine is about to fail, intercepting... " + pos.toString());
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 128; ++j) {
                        for (int k = 0; k < 16; ++k) {
                            if (this.trySetChangeable(world, pos.func_177982_a(i, j, k), itemTileBlock, entityItem)) {
                                return vec;
                            }
                            if (this.trySetChangeable(world, pos.func_177982_a(i, -j, k), itemTileBlock, entityItem)) {
                                return vec;
                            }
                            if (this.trySetChangeable(world, pos.func_177982_a(-i, j, k), itemTileBlock, entityItem)) {
                                return vec;
                            }
                            if (this.trySetChangeable(world, pos.func_177982_a(-i, -j, k), itemTileBlock, entityItem)) {
                                return vec;
                            }
                            if (this.trySetChangeable(world, pos.func_177982_a(i, j, -k), itemTileBlock, entityItem)) {
                                return vec;
                            }
                            if (this.trySetChangeable(world, pos.func_177982_a(i, -j, -k), itemTileBlock, entityItem)) {
                                return vec;
                            }
                            if (this.trySetChangeable(world, pos.func_177982_a(-i, j, -k), itemTileBlock, entityItem)) {
                                return vec;
                            }
                            if (!this.trySetChangeable(world, pos.func_177982_a(-i, -j, -k), itemTileBlock, entityItem)) continue;
                            return vec;
                        }
                    }
                }
                RLTweaker.logger.error("CarryOn tile was unable to find safe place to be");
                ErrorUtil.logSilent("CarryOn COItemDropped No Safe Place");
                return null;
            }
            catch (Exception e) {
                ErrorUtil.logSilent("CarryOn COItemDropped Exception");
                return null;
            }
        }

        private boolean trySetChangeable(World world, BlockPos newPos, Block itemTileBlock, EntityItem entityItem) {
            if (this.isChangeable(world, newPos, itemTileBlock)) {
                RLTweaker.logger.debug("CarryOn tile is being set to: " + newPos.toString());
                entityItem.func_70107_b((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p());
                return true;
            }
            return false;
        }

        private boolean isChangeable(World world, BlockPos pos, Block itemTileBlock) {
            return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && itemTileBlock.func_176196_c(world, pos) && this.testQuarkChestQuickly(world, pos, itemTileBlock);
        }

        private boolean testQuarkChestQuickly(World world, BlockPos pos, Block itemTileBlock) {
            if (CarryOnHandler.this.reflectorQuark != null && ModConfig.server.carryon.quarkChestFix && CarryOnHandler.this.reflectorQuark.isBlockCustomChest(itemTileBlock)) {
                if (world.func_180495_p(pos.func_177978_c()).func_177230_c() == itemTileBlock) {
                    return false;
                }
                if (world.func_180495_p(pos.func_177974_f()).func_177230_c() == itemTileBlock) {
                    return false;
                }
                if (world.func_180495_p(pos.func_177968_d()).func_177230_c() == itemTileBlock) {
                    return false;
                }
                if (world.func_180495_p(pos.func_177976_e()).func_177230_c() == itemTileBlock) {
                    return false;
                }
            }
            return true;
        }
    }
}

