/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.IceAndFireReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import com.charles445.rltweaker.util.LootUtil;
import com.charles445.rltweaker.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.GameData;

public class IceAndFireHandler {
    private IceAndFireReflect reflector;

    public IceAndFireHandler() {
        block4: {
            try {
                this.reflector = new IceAndFireReflect();
                if (ModConfig.server.iceandfire.rightHandDragonInteraction) {
                    CompatUtil.wrapSpecificHandler("IAFUseItem", x$0 -> new IAFUseItem((IEventListener)x$0), "com.github.alexthe666.iceandfire.event.EventLiving", "onEntityUseItem");
                    CompatUtil.wrapSpecificHandler("IAFUseItem", x$0 -> new IAFUseItem((IEventListener)x$0), "com.github.alexthe666.iceandfire.event.ServerEvents", "onEntityUseItem");
                }
                if (ModConfig.server.iceandfire.rlcraftTradeBalancing) {
                    this.attemptRemoveRLCraftTrades();
                }
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup IceAndFireHandler!", (Throwable)e);
                ErrorUtil.logSilent("IceAndFireHandler Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (ModConfig.server.iceandfire.rightHandDragonInteraction && event.getHand() == EnumHand.OFF_HAND && this.reflector.c_ItemDragonHornStatic != null && this.reflector.c_EntityDragonBase.isInstance(event.getTarget())) {
            ItemStack offhand = event.getEntityPlayer().func_184592_cb();
            if (offhand.func_190926_b()) {
                return;
            }
            if (this.reflector.c_ItemDragonHornStatic.isInstance(offhand.func_77973_b())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onMobGriefing(EntityMobGriefingEvent event) {
        if (ModConfig.server.iceandfire.statueMobGriefingFix && event.getEntity() instanceof EntityLiving) {
            EntityLiving entity = (EntityLiving)event.getEntity();
            if (!entity.field_70170_p.field_72995_K && entity.func_98052_bS() && this.reflector.getIsStone((Entity)entity)) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        ResourceLocation entityResource;
        EntityEntry entry;
        Class entityClazz;
        ItemStack readStack;
        EntityItem itemEntity;
        if (ModConfig.server.iceandfire.statueDataFixes && !event.getWorld().field_72995_K && event.getEntity() instanceof EntityItem && this.reflector.c_ItemStoneStatue.isInstance((itemEntity = (EntityItem)event.getEntity()).func_92059_d().func_77973_b()) && (readStack = itemEntity.func_92059_d()).func_77978_p() != null && (entityClazz = (entry = (EntityEntry)GameData.getEntityRegistry().getValue(readStack.func_77978_p().func_74762_e("IAFStoneStatueEntityID"))).getEntityClass()) != null && (entityResource = EntityList.func_191306_a((Class)entityClazz)) != null && entityResource.toString().equals("lycanitesmobs:kobold")) {
            ItemStack writeStack = readStack.func_77946_l();
            writeStack.func_77978_p().func_82580_o("Items");
            itemEntity.func_92058_a(writeStack);
        }
        if (ModConfig.server.iceandfire.myrmexQueenTradeFix && !event.getWorld().field_72995_K && this.reflector.c_EntityMyrmexQueen.isInstance(event.getEntity())) {
            Entity myrmexBase = event.getEntity();
            try {
                MerchantRecipeList trades = this.reflector.getMyrmexTrades(myrmexBase);
                if (trades != null) {
                    boolean myrmexIsJungle = this.reflector.isMyrmexJungle(myrmexBase);
                    boolean hasJungle = false;
                    boolean hasDesert = false;
                    for (MerchantRecipe trade : trades) {
                        String reg = trade.func_77394_a().func_77973_b().getRegistryName().toString();
                        if (reg.equals("iceandfire:myrmex_desert_resin")) {
                            hasDesert = true;
                            continue;
                        }
                        if (!reg.equals("iceandfire:myrmex_jungle_resin")) continue;
                        hasJungle = true;
                    }
                    if (myrmexIsJungle && hasDesert || !myrmexIsJungle && hasJungle) {
                        RLTweaker.logger.info("Clearing broken myrmex queen trades: " + myrmexBase.func_180425_c().toString());
                        this.reflector.resetMyrmexTrades(myrmexBase);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                ErrorUtil.logSilent("IceAndFireHandler Myrmex Queen Trades Failure");
            }
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (!ModConfig.server.iceandfire.deathwormEggsIgnoreLooting) {
            return;
        }
        switch (event.getName().toString()) {
            case "iceandfire:deathworm_red_giant": 
            case "iceandfire:deathworm_red": 
            case "iceandfire:deathworm_tan_giant": 
            case "iceandfire:deathworm_tan": 
            case "iceandfire:deathworm_white_giant": 
            case "iceandfire:deathworm_white": {
                this.removeDeathWormEggLooting(event, event.getName());
                break;
            }
        }
    }

    private void removeDeathWormEggLooting(LootTableLoadEvent event, ResourceLocation resource) {
        LootTable table = event.getTable();
        if (table == null) {
            return;
        }
        try {
            List<LootPool> pools = this.reflector.getPools(table);
            if (pools == null) {
                return;
            }
            for (LootPool pool : pools) {
                List<LootEntry> poolEntries;
                if (!pool.getName().equals(resource.func_110623_a()) || (poolEntries = this.reflector.getEntries(pool)) == null) continue;
                for (LootEntry entry : poolEntries) {
                    LootFunction[] functions;
                    if (entry == null || !(entry instanceof LootEntryItem) || !entry.getEntryName().contains("deathworm_egg") || (functions = this.reflector.getFunctions((LootEntryItem)entry)) == null) continue;
                    for (int i = 0; i < functions.length; ++i) {
                        LootFunction function = functions[i];
                        if (!(function instanceof LootingEnchantBonus)) continue;
                        functions[i] = new LootUtil.DoNothingFunction();
                        RLTweaker.logger.debug("Removed LootingEnchantBonus for deathworm egg: " + resource.toString());
                    }
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ErrorUtil.logSilent("IAF Death Worm Egg Looting Invocation");
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (!ModConfig.server.iceandfire.stopGorgonTargetingPlayerStatues) {
            return;
        }
        if (this.reflector.c_EntityGorgon.isInstance(event.getEntity()) && this.reflector.c_EntityStoneStatue.isInstance(event.getTarget()) && event.getEntityLiving() instanceof EntityLiving) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    private void attemptRemoveRLCraftTrades() {
        try {
            Class.forName("com.github.alexthe666.iceandfire.core.ModVillagers");
        }
        catch (Exception e) {
            return;
        }
        try {
            Class<?> c_ModVillagers = Class.forName("com.github.alexthe666.iceandfire.core.ModVillagers");
            Object o_ModVillagers_INSTANCE = ReflectUtil.findField(c_ModVillagers, "INSTANCE").get(null);
            Map o_ModVillagers_professions = (Map)ReflectUtil.findField(c_ModVillagers, "professions").get(o_ModVillagers_INSTANCE);
            VillagerRegistry.VillagerCareer craftsmanCareer = ((VillagerRegistry.VillagerProfession)o_ModVillagers_professions.get(1)).getCareer(0);
            Field f_VillagerCareer_trades = ReflectUtil.findField(VillagerRegistry.VillagerCareer.class, "trades");
            Field f_buyingItem = ReflectUtil.findField(Class.forName("com.github.alexthe666.iceandfire.core.ModVillagers$SapphireForItems"), "buyingItem");
            this.removeAllSapphireForItemWithSold(new ResourceLocation("minecraft", "snow"), (List)f_VillagerCareer_trades.get(craftsmanCareer), f_buyingItem);
        }
        catch (Exception e) {
            RLTweaker.logger.error("Failed to remove RLCraft balancing trades", (Throwable)e);
            ErrorUtil.logSilent("Ice and Fire RLCraft Trade Removal");
        }
    }

    private void removeAllListEmeraldWithBought(ResourceLocation itemRegistry, List<List<EntityVillager.ITradeList>> trades, Field f_itemToBuy) throws IllegalArgumentException, IllegalAccessException {
        for (List<EntityVillager.ITradeList> tradeLevel : trades) {
            Iterator<EntityVillager.ITradeList> iterator = tradeLevel.iterator();
            while (iterator.hasNext()) {
                ItemStack stack;
                EntityVillager.ITradeList tradeList = iterator.next();
                if (!tradeList.getClass().getName().equals("com.github.alexthe666.iceandfire.core.ModVillagers$ListItemForSapphires") || !(stack = (ItemStack)f_itemToBuy.get(tradeList)).func_77973_b().getRegistryName().equals((Object)itemRegistry)) continue;
                iterator.remove();
                RLTweaker.logger.info("Removed a snow villager trade: " + itemRegistry.toString());
            }
        }
    }

    private void removeAllSapphireForItemWithSold(ResourceLocation itemRegistry, List<List<EntityVillager.ITradeList>> trades, Field f_buyingItem) throws IllegalArgumentException, IllegalAccessException {
        for (List<EntityVillager.ITradeList> tradeLevel : trades) {
            Iterator<EntityVillager.ITradeList> iterator = tradeLevel.iterator();
            while (iterator.hasNext()) {
                Item item;
                EntityVillager.ITradeList tradeList = iterator.next();
                if (!tradeList.getClass().getName().equals("com.github.alexthe666.iceandfire.core.ModVillagers$SapphireForItems") || !(item = (Item)f_buyingItem.get(tradeList)).getRegistryName().equals((Object)itemRegistry)) continue;
                iterator.remove();
                RLTweaker.logger.info("Removed a snow villager trade: " + itemRegistry.toString());
            }
        }
    }

    public class IAFUseItem {
        private IEventListener handler;

        public IAFUseItem(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onUseItem(PlayerInteractEvent.RightClickItem event) {
            if (ModConfig.server.iceandfire.rightHandDragonInteraction && event.getHand() == EnumHand.OFF_HAND) {
                return;
            }
            this.handler.invoke((Event)event);
        }
    }
}

