/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PotionCoreHandler {
    boolean controllableJumpBoost;

    public PotionCoreHandler() {
        block3: {
            this.controllableJumpBoost = false;
            try {
                if (ModConfig.server.potioncore.capJumpBoost) {
                    CompatUtil.wrapSpecificHandler("PCJump", x$0 -> new PCJump((IEventListener)x$0), "com.tmtravlr.potioncore.PotionCoreEventHandler", "onLivingJump");
                }
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup PotionCoreHandler!", (Throwable)e);
                ErrorUtil.logSilent("PotionCore Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public class PCJump {
        private IEventListener handler;

        public PCJump(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onJump(LivingEvent.LivingJumpEvent event) {
            EntityLivingBase living = event.getEntityLiving();
            PotionEffect jumpEffect = living.func_70660_b(MobEffects.field_76430_j);
            if (jumpEffect != null && (jumpEffect.func_76458_c() < 0 || jumpEffect.func_76458_c() > 127)) {
                if (living.field_70170_p.field_72995_K) {
                    living.getEntityData().func_74757_a("Potion Core - Jump Boost Jumping", false);
                }
                return;
            }
            this.handler.invoke((Event)event);
            if (jumpEffect == null && living.field_70170_p.field_72995_K) {
                living.getEntityData().func_74757_a("Potion Core - Jump Boost Jumping", false);
            }
        }

        @SubscribeEvent
        public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                return;
            }
            EntityPlayer player = event.player;
            if (player == null) {
                return;
            }
            World world = player.field_70170_p;
            if (world == null) {
                return;
            }
            if (!world.field_72995_K) {
                return;
            }
            double jbh = event.player.getEntityData().func_74769_h("Potion Core - Jump Boost Height");
            if (jbh > 127.0) {
                ErrorUtil.logSilent("PotionCore Invalid Jump Boost Height");
                event.player.getEntityData().func_74780_a("Potion Core - Jump Boost Height", 1.75);
            }
        }

        @SubscribeEvent
        public void potionApplicable(PotionEvent.PotionApplicableEvent event) {
            EntityLivingBase living = event.getEntityLiving();
            PotionEffect newEffect = event.getPotionEffect();
            if (newEffect == null) {
                return;
            }
            if (!(living instanceof EntityPlayer)) {
                return;
            }
            if (!living.field_70170_p.field_72995_K) {
                return;
            }
            if (newEffect.func_188419_a() == MobEffects.field_76430_j) {
                PotionEffect oldEffect = living.func_70660_b(MobEffects.field_76430_j);
                if (oldEffect == null) {
                    return;
                }
                if (newEffect.func_76458_c() < 0 && oldEffect.func_76458_c() >= 0) {
                    living.func_184589_d(MobEffects.field_76430_j);
                }
            }
        }
    }
}

