/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.clipboard;

import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.capability.RCEntityInfo;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.commands.parameters.IvP;
import ivorius.reccomplex.commands.parameters.expect.RCE;
import ivorius.reccomplex.operation.OperationGenerateStructure;
import ivorius.reccomplex.operation.OperationRegistry;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.MCP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.MCE;
import ivorius.reccomplex.utils.RCBlockAreas;
import ivorius.reccomplex.world.gen.feature.StructureGenerator;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class CommandPaste
extends CommandExpecting {
    public String func_71517_b() {
        return RCConfig.commandPrefix + "paste";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void expect(Expect expect) {
        expect.then(MCE.pos("x", "y", "z")).named("rotation", "r").then(MCE::rotation).named("seed", new String[0]).words(RCE::randomString).flag("mirror", "m").flag("generate", "g").flag("select", "s");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        EntityPlayerMP entityPlayerMP = CommandPaste.func_71521_c((ICommandSender)sender);
        RCEntityInfo entityInfo = RCCommands.getStructureEntityInfo(entityPlayerMP, null);
        NBTTagCompound worldData = entityInfo.getWorldDataClipboard();
        if (worldData == null) {
            throw RecurrentComplex.translations.commandException("commands.strucPaste.noClipboard", new Object[0]);
        }
        WorldServer world = (WorldServer)sender.func_130014_f_();
        BlockPos pos = (BlockPos)parameters.get(MCP.pos("x", "y", "z", sender.func_180425_c(), false)).require();
        AxisAlignedTransform2D transform = parameters.get(IvP.transform("rotation", "mirror")).optional().orElse(AxisAlignedTransform2D.ORIGINAL);
        String seed = parameters.get("seed").optional().orElse(null);
        boolean generate = parameters.has("generate");
        GenericStructure structure = GenericStructure.createDefaultStructure();
        structure.worldDataCompound = worldData;
        OperationRegistry.queueOperation(new OperationGenerateStructure(structure, null, transform, pos, !generate).withSeed(seed).prepare(world), sender);
        if (parameters.has("select")) {
            StructureGenerator<GenericStructure.InstanceData> generator = new StructureGenerator<GenericStructure.InstanceData>(structure).transform(transform).lowerCoord(pos);
            RCCommands.select(sender, RCBlockAreas.from(generator.boundingBox().get()));
        }
    }
}

