/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.files.loading;

import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.events.FileLoadEvent;
import ivorius.reccomplex.events.RCEventBus;
import ivorius.reccomplex.files.loading.FileLoadContext;
import ivorius.reccomplex.files.loading.FileLoaderAdapter;
import ivorius.reccomplex.files.loading.LeveledRegistry;
import java.nio.file.Path;
import javax.annotation.ParametersAreNonnullByDefault;

public abstract class FileLoaderRegistry<S>
extends FileLoaderAdapter {
    public LeveledRegistry<? super S> registry;

    public FileLoaderRegistry(String suffix, LeveledRegistry<? super S> registry) {
        super(suffix);
        this.registry = registry;
    }

    @Override
    @ParametersAreNonnullByDefault
    public boolean loadFile(Path path, String id, FileLoadContext context) {
        String domain = context.domain;
        boolean active = context.active;
        Object s = null;
        try {
            s = this.read(path, id);
        }
        catch (Exception e) {
            RecurrentComplex.logger.error("Error reading file: " + path, (Throwable)e);
        }
        if (s != null) {
            FileLoadEvent.Pre<Object> event = new FileLoadEvent.Pre<Object>(s, this.suffix, id, domain, path, active);
            if (!RCEventBus.INSTANCE.post(event) && RCConfig.shouldResourceLoad(this.suffix, id, domain)) {
                active = event.active;
                this.registry.register(id, domain, s, active, context.level);
                RCEventBus.INSTANCE.post(new FileLoadEvent.Post<Object>(s, this.suffix, id, domain, path, active));
            }
            return true;
        }
        return false;
    }

    public abstract S read(Path var1, String var2) throws Exception;

    @Override
    @ParametersAreNonnullByDefault
    public void clearFiles(LeveledRegistry.Level level) {
        this.registry.clear(level);
    }
}

