/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.utils;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.party.IParty;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.storage.DBEntry;
import betterquesting.questing.party.PartyManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ParticipantInfo {
    public final EntityPlayer PLAYER;
    public final UUID UUID;
    public final List<UUID> ALL_UUIDS;
    public final List<EntityPlayer> ACTIVE_PLAYERS;
    public final List<UUID> ACTIVE_UUIDS;
    public final DBEntry<IParty> PARTY_INSTANCE;

    public ParticipantInfo(@Nonnull EntityPlayer player) {
        this.PLAYER = player;
        this.UUID = QuestingAPI.getQuestingUUID(player);
        this.PARTY_INSTANCE = PartyManager.INSTANCE.getParty(this.UUID);
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (this.PARTY_INSTANCE == null || server == null || player instanceof FakePlayer) {
            this.ACTIVE_PLAYERS = Collections.singletonList(player);
            this.ACTIVE_UUIDS = Collections.singletonList(this.UUID);
            this.ALL_UUIDS = Collections.singletonList(this.UUID);
            return;
        }
        ArrayList<EntityPlayerMP> actPl = new ArrayList<EntityPlayerMP>();
        ArrayList<UUID> actID = new ArrayList<UUID>();
        ArrayList<UUID> allID = new ArrayList<UUID>();
        for (UUID mem : this.PARTY_INSTANCE.getValue().getMembers()) {
            allID.add(mem);
            EntityPlayerMP pMem = server.func_184103_al().func_177451_a(mem);
            if (pMem == null) continue;
            actPl.add(pMem);
            actID.add(mem);
        }
        this.ACTIVE_PLAYERS = Collections.unmodifiableList(actPl);
        this.ACTIVE_UUIDS = Collections.unmodifiableList(actID);
        this.ALL_UUIDS = Collections.unmodifiableList(allID);
    }

    public void markDirty(@Nonnull List<Integer> questIDs) {
        QuestCache qc = (QuestCache)this.PLAYER.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc != null) {
            questIDs.forEach(qc::markQuestDirty);
        }
    }

    public void markDirtyParty(@Nonnull List<Integer> questIDs) {
        if (this.ACTIVE_PLAYERS.size() <= 0 || questIDs.size() <= 0) {
            return;
        }
        this.ACTIVE_PLAYERS.forEach(value -> {
            QuestCache qc = (QuestCache)value.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            if (qc != null) {
                questIDs.forEach(qc::markQuestDirty);
            }
        });
    }

    @Nonnull
    public int[] getSharedQuests() {
        TreeSet active = new TreeSet();
        this.ACTIVE_PLAYERS.forEach(p -> {
            QuestCache qc = (QuestCache)p.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            if (qc != null) {
                for (int value : qc.getActiveQuests()) {
                    active.add(value);
                }
            }
        });
        int[] shared = new int[active.size()];
        int i = 0;
        Iterator iterator = active.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            shared[i++] = value;
        }
        return shared;
    }
}

