/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.storage.DBEntry;
import betterquesting.commands.QuestCommandBase;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.storage.NameCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.server.permission.DefaultPermissionLevel;

public class QuestCommandReset
extends QuestCommandBase {
    @Override
    public String getUsageSuffix() {
        return "[all|<quest_id>] [username|uuid]";
    }

    @Override
    public boolean validArgs(String[] args) {
        return args.length == 2 || args.length == 3;
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("all");
            for (DBEntry i : QuestDatabase.INSTANCE.getEntries()) {
                list.add("" + i.getID());
            }
            return list;
        }
        if (args.length == 3) {
            return CommandBase.func_175762_a((String[])args, NameCache.INSTANCE.getAllNames());
        }
        return Collections.emptyList();
    }

    @Override
    public String getCommand() {
        return "reset";
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player;
        String action = args[1];
        UUID uuid = null;
        if (args.length == 3 && (uuid = this.findPlayerID(server, sender, args[2])) == null) {
            throw this.getException(command);
        }
        String pName = uuid == null ? "NULL" : NameCache.INSTANCE.getName(uuid);
        EntityPlayerMP entityPlayerMP = player = uuid == null ? null : server.func_184103_al().func_177451_a(uuid);
        if (action.equalsIgnoreCase("all")) {
            for (DBEntry entry : QuestDatabase.INSTANCE.getEntries()) {
                if (uuid != null) {
                    ((IQuest)entry.getValue()).resetUser(uuid, true);
                    continue;
                }
                ((IQuest)entry.getValue()).resetUser(null, true);
            }
            if (uuid != null) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.reset.player_all", new Object[]{pName}));
                if (player != null) {
                    NetQuestSync.sendSync(player, null, false, true);
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.reset.all_all", new Object[0]));
                NetQuestSync.quickSync(-1, false, true);
            }
        } else {
            try {
                int id = Integer.parseInt(action.trim());
                IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(id);
                if (uuid != null) {
                    quest.resetUser(uuid, true);
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.reset.player_single", new Object[]{new TextComponentTranslation(quest.getProperty(NativeProps.NAME), new Object[0]), pName}));
                    if (player != null) {
                        NetQuestSync.sendSync(player, new int[]{id}, false, true);
                    }
                } else {
                    quest.resetUser(null, true);
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.reset.all_single", new Object[]{new TextComponentTranslation(quest.getProperty(NativeProps.NAME), new Object[0])}));
                    NetQuestSync.quickSync(id, false, true);
                }
            }
            catch (Exception e) {
                throw this.getException(command);
            }
        }
    }

    @Override
    public boolean isArgUsername(String[] args, int index) {
        return index == 2;
    }

    @Override
    public String getPermissionNode() {
        return "betterquesting.command.admin.reset";
    }

    @Override
    public DefaultPermissionLevel getPermissionLevel() {
        return DefaultPermissionLevel.OP;
    }

    @Override
    public String getPermissionDescription() {
        return "Permission to erases quest completion data for the given user";
    }
}

