/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.utils;

import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.base.ConfigHandler;
import codersafterdark.reskillable.base.LevelLockHandler;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Utils {
    public static String formatRequirements(String[] requirements) {
        if (requirements == null) {
            return "null";
        }
        String reqString = Arrays.stream(requirements).map(s -> s + ", ").collect(Collectors.joining());
        if (!reqString.isEmpty()) {
            reqString = reqString.substring(0, reqString.length() - 2);
        }
        return reqString;
    }

    public static ITextComponent getError(RequirementHolder holder, PlayerData data, TextComponentTranslation error) {
        TextComponentTranslation error2 = new TextComponentTranslation("compatskills.misc.requirements", new Object[0]);
        String reqString = holder.getRequirements().stream().map(requirement -> "\n " + requirement.getToolTip(data) + ' ').collect(Collectors.joining());
        return new TextComponentString(error.func_150261_e() + ' ' + error2.func_150261_e() + ' ' + reqString);
    }

    public static RayTraceResult getLookingAt(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        Vec3d eyes = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        float pitch = -player.field_70125_A * ((float)Math.PI / 180);
        float yaw = -player.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI;
        double reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        double pitchReach = (double)(-MathHelper.func_76134_b((float)pitch)) * reach;
        Vec3d vec3d = eyes.func_72441_c((double)MathHelper.func_76126_a((float)yaw) * pitchReach, (double)MathHelper.func_76126_a((float)pitch) * reach, (double)MathHelper.func_76134_b((float)yaw) * pitchReach);
        return player.func_130014_f_().func_72933_a(eyes, vec3d);
    }

    public static Entity lookingAt(EntityPlayer player) {
        double reach;
        if (player == null) {
            return null;
        }
        double distance = reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d eyes = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        RayTraceResult objectMouseOver = Utils.getLookingAt(player);
        if (objectMouseOver != null) {
            distance = objectMouseOver.field_72307_f.func_72438_d(eyes);
        }
        Vec3d look = player.func_70676_i(1.0f);
        double lookReachX = look.field_72450_a * reach;
        double lookReachY = look.field_72448_b * reach;
        double lookReachZ = look.field_72449_c * reach;
        List list = player.func_130014_f_().func_175674_a((Entity)player, player.func_174813_aQ().func_72321_a(lookReachX, lookReachY, lookReachZ).func_72314_b(1.0, 1.0, 1.0), ent -> ent != null && (!(ent instanceof EntityPlayer) || !((EntityPlayer)ent).func_175149_v()) && ent.func_70067_L());
        double bestDistance = distance;
        Vec3d direction = eyes.func_72441_c(lookReachX, lookReachY, lookReachZ);
        Entity hitEntity = null;
        for (Entity entity : list) {
            AxisAlignedBB entityBB = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            if (entityBB.func_72318_a(eyes)) {
                return entity;
            }
            RayTraceResult raytraceresult = entityBB.func_72327_a(eyes, direction);
            if (raytraceresult == null) continue;
            double dist = eyes.func_72438_d(raytraceresult.field_72307_f);
            if (dist == 0.0) {
                return entity;
            }
            if (!(dist < bestDistance)) continue;
            hitEntity = entity;
            bestDistance = dist;
        }
        return hitEntity;
    }

    public static String getEntityID(Entity entity) {
        for (EntityEntry entry : ForgeRegistries.ENTITIES.getValuesCollection()) {
            if (entry.getEntityClass() != entity.getClass()) continue;
            return entry.getRegistryName() != null ? entry.getRegistryName().toString() : "no_registry_name";
        }
        return "no_registry_name";
    }

    public static boolean skipPlayer(EntityPlayer player) {
        return player == null || !ConfigHandler.enforceOnCreative && player.func_184812_l_() || !ConfigHandler.enforceFakePlayers && LevelLockHandler.isFake((Entity)player);
    }
}

