/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeForest;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import prospector.traverse.config.TraverseConfig;
import prospector.traverse.shadow.shootingstar.version.Version;
import prospector.traverse.world.biomes.BiomeAridHighland;
import prospector.traverse.world.biomes.BiomeAutumnalWoodedHills;
import prospector.traverse.world.biomes.BiomeAutumnalWoods;
import prospector.traverse.world.biomes.BiomeBadlands;
import prospector.traverse.world.biomes.BiomeCanyon;
import prospector.traverse.world.biomes.BiomeCliffs;
import prospector.traverse.world.biomes.BiomeConiferousForest;
import prospector.traverse.world.biomes.BiomeCragCliffs;
import prospector.traverse.world.biomes.BiomeDesertShrubland;
import prospector.traverse.world.biomes.BiomeForestedHills;
import prospector.traverse.world.biomes.BiomeGlacier;
import prospector.traverse.world.biomes.BiomeLushHills;
import prospector.traverse.world.biomes.BiomeLushSwamp;
import prospector.traverse.world.biomes.BiomeMeadow;
import prospector.traverse.world.biomes.BiomeMiniJungle;
import prospector.traverse.world.biomes.BiomeMountainousDesert;
import prospector.traverse.world.biomes.BiomeRedDesert;
import prospector.traverse.world.biomes.BiomeRockyPlains;
import prospector.traverse.world.biomes.BiomeRockyPlateau;
import prospector.traverse.world.biomes.BiomeThicket;
import prospector.traverse.world.biomes.BiomeWoodlands;

@Mod.EventBusSubscriber
public class TraverseWorld {
    public static final Version V0 = new Version(1, 0, 0);
    public static final Version V1 = new Version(1, 1, 0);
    public static final Version V2 = new Version(1, 2, 0);
    public static final Version V3 = new Version(1, 3, 0);
    public static final Version V4 = new Version(1, 4, 0);
    public static final Version V5 = new Version(1, 5, 0);
    public static final VillageReplacements NO_VILLAGES = originalState -> null;
    public static final VillageReplacements NO_REPLACEMENTS = originalState -> originalState;
    public static final VillageReplacements RED_DESERT_REPLACEMENTS = originalState -> {
        if (originalState.func_177230_c() == Blocks.field_150364_r || originalState.func_177230_c() == Blocks.field_150363_s) {
            return Blocks.field_180395_cM.func_176223_P();
        }
        if (originalState.func_177230_c() == Blocks.field_150347_e) {
            return Blocks.field_180395_cM.func_176223_P().func_177226_a((IProperty)BlockRedSandstone.field_176336_a, (Comparable)BlockRedSandstone.EnumType.DEFAULT);
        }
        if (originalState.func_177230_c() == Blocks.field_150344_f) {
            return Blocks.field_180395_cM.func_176223_P().func_177226_a((IProperty)BlockRedSandstone.field_176336_a, (Comparable)BlockRedSandstone.EnumType.SMOOTH);
        }
        if (originalState.func_177230_c() == Blocks.field_150476_ad) {
            return Blocks.field_180396_cN.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, originalState.func_177229_b((IProperty)BlockStairs.field_176309_a));
        }
        if (originalState.func_177230_c() == Blocks.field_150446_ar) {
            return Blocks.field_180396_cN.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, originalState.func_177229_b((IProperty)BlockStairs.field_176309_a));
        }
        if (originalState.func_177230_c() == Blocks.field_150351_n) {
            return Blocks.field_180395_cM.func_176223_P();
        }
        return originalState;
    };
    public static final VillageReplacements DESERT_REPLACEMENTS = originalState -> {
        if (originalState.func_177230_c() == Blocks.field_150364_r || originalState.func_177230_c() == Blocks.field_150363_s) {
            return Blocks.field_150322_A.func_176223_P();
        }
        if (originalState.func_177230_c() == Blocks.field_150347_e) {
            return Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.DEFAULT);
        }
        if (originalState.func_177230_c() == Blocks.field_150344_f) {
            return Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH);
        }
        if (originalState.func_177230_c() == Blocks.field_150476_ad) {
            return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, originalState.func_177229_b((IProperty)BlockStairs.field_176309_a));
        }
        if (originalState.func_177230_c() == Blocks.field_150446_ar) {
            return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, originalState.func_177229_b((IProperty)BlockStairs.field_176309_a));
        }
        if (originalState.func_177230_c() == Blocks.field_150351_n) {
            return Blocks.field_150322_A.func_176223_P();
        }
        return originalState;
    };
    public static List<TraverseBiomeEntry> biomeList = new ArrayList<TraverseBiomeEntry>();
    public static Map<Biome, VillageReplacements> villageReplacementBiomes = new HashMap<Biome, VillageReplacements>();
    public static Biome autumnalWoodsBiome = new BiomeAutumnalWoods();
    public static Biome woodlandsBiome = new BiomeWoodlands();
    public static Biome miniJungleBiome = new BiomeMiniJungle();
    public static Biome meadowBiome = new BiomeMeadow();
    public static Biome lushSwampBiome = new BiomeLushSwamp();
    public static Biome redDesertBiome = new BiomeRedDesert();
    public static Biome temperateRainforestBiome = new BiomeConiferousForest(false);
    public static Biome badlandsBiome = new BiomeBadlands();
    public static Biome mountainousDesertBiome = new BiomeMountainousDesert();
    public static Biome rockyPlateauBiome = new BiomeRockyPlateau();
    public static Biome forestedHillsBiome = new BiomeForestedHills(BiomeForest.Type.NORMAL, "Forested Hills");
    public static Biome birchForestedHillsBiome = new BiomeForestedHills(BiomeForest.Type.BIRCH, "Birch Forested Hills");
    public static Biome autumnalWoodedHillsBiome = new BiomeAutumnalWoodedHills();
    public static Biome cliffsBiome = new BiomeCliffs();
    public static Biome glacierBiome = new BiomeGlacier(false);
    public static Biome glacierSpikesBiome = new BiomeGlacier(true);
    public static Biome snowyConiferousForestBiome = new BiomeConiferousForest(true);
    public static Biome lushHillsBiome = new BiomeLushHills();
    public static Biome canyonBiome = new BiomeCanyon();
    public static Biome cragCliffsBiome = new BiomeCragCliffs();
    public static Biome desertShrublandBiome = new BiomeDesertShrubland();
    public static Biome thicketBiome = new BiomeThicket();
    public static Biome aridHighlandBiome = new BiomeAridHighland();
    public static Biome rockyPlainsBiome = new BiomeRockyPlains();

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        TraverseWorld.register(V0, autumnalWoodsBiome, BiomeManager.BiomeType.COOL, "autumnal_woods", 8, TraverseConfig.disableAutumnalWoods, true, event, BiomeDictionary.Type.FOREST);
        TraverseWorld.register(V0, woodlandsBiome, BiomeManager.BiomeType.WARM, "woodlands", 9, TraverseConfig.disableWoodlands, true, NO_REPLACEMENTS, event, BiomeDictionary.Type.PLAINS);
        TraverseWorld.register(V0, miniJungleBiome, BiomeManager.BiomeType.WARM, "mini_jungle", 3, TraverseConfig.disableMiniJungle, true, event, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET);
        TraverseWorld.register(V0, meadowBiome, BiomeManager.BiomeType.COOL, "meadow", 7, TraverseConfig.disableMeadow, true, NO_REPLACEMENTS, event, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET);
        TraverseWorld.register(V0, lushSwampBiome, BiomeManager.BiomeType.WARM, "green_swamp", 6, TraverseConfig.disableLushSwamp, false, event, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        TraverseWorld.register(V0, redDesertBiome, BiomeManager.BiomeType.DESERT, "red_desert", 6, TraverseConfig.disableRedDesert, false, RED_DESERT_REPLACEMENTS, event, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
        TraverseWorld.register(V0, temperateRainforestBiome, BiomeManager.BiomeType.COOL, "temperate_rainforest", 8, TraverseConfig.disableTemperateRainforest, true, event, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS);
        TraverseWorld.register(V1, badlandsBiome, BiomeManager.BiomeType.WARM, "badlands", 5, TraverseConfig.disableBadlands, false, NO_REPLACEMENTS, event, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
        TraverseWorld.register(V1, mountainousDesertBiome, BiomeManager.BiomeType.DESERT, "mountainous_desert", 2, TraverseConfig.disableMountainousDesert, false, event, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY);
        TraverseWorld.register(V1, rockyPlateauBiome, BiomeManager.BiomeType.WARM, "rocky_plateau", 4, TraverseConfig.disableRockyPlateau, false, NO_REPLACEMENTS, event, BiomeDictionary.Type.HOT, BiomeDictionary.Type.MOUNTAIN);
        TraverseWorld.register(V1, forestedHillsBiome, BiomeManager.BiomeType.COOL, "forested_hills", 6, TraverseConfig.disableForestedHills, true, event, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        TraverseWorld.register(V1, birchForestedHillsBiome, BiomeManager.BiomeType.COOL, "birch_forested_hills", 2, TraverseConfig.disableBirchForestedHills, true, event, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        TraverseWorld.register(V1, autumnalWoodedHillsBiome, BiomeManager.BiomeType.COOL, "autumnal_wooded_hills", 1, TraverseConfig.disableAutumnalWoodedHills, true, event, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        TraverseWorld.register(V2, cliffsBiome, BiomeManager.BiomeType.COOL, "cliffs", 2, TraverseConfig.disableCliffs, false, event, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.HILLS);
        TraverseWorld.register(V2, glacierBiome, BiomeManager.BiomeType.ICY, "glacier", 6, TraverseConfig.disableGlacier, false, event, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
        TraverseWorld.register(V2, glacierSpikesBiome, BiomeManager.BiomeType.ICY, "glacier_spikes", 2, TraverseConfig.disableGlacierSpikes, false, event, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
        TraverseWorld.register(V2, snowyConiferousForestBiome, BiomeManager.BiomeType.ICY, "snowy_coniferous_forest", 5, TraverseConfig.disableSnowyConiferousForest, true, event, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS);
        TraverseWorld.register(V3, lushHillsBiome, BiomeManager.BiomeType.COOL, "lush_hills", 6, TraverseConfig.disableLushHills, true, NO_REPLACEMENTS, event, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET);
        TraverseWorld.register(V3, canyonBiome, BiomeManager.BiomeType.DESERT, "canyon", 5, TraverseConfig.disableCanyon, false, event, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD);
        TraverseWorld.register(V3, cragCliffsBiome, BiomeManager.BiomeType.COOL, "crag_cliffs", 4, TraverseConfig.disableCragCliffs, false, event, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DEAD);
        TraverseWorld.register(V4, desertShrublandBiome, BiomeManager.BiomeType.DESERT, "desert_shrubland", 5, TraverseConfig.disableDesertShrubland, false, DESERT_REPLACEMENTS, event, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DEAD);
        TraverseWorld.register(V5, thicketBiome, BiomeManager.BiomeType.WARM, "thicket", 6, TraverseConfig.disableThicket, true, event, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);
        TraverseWorld.register(V5, aridHighlandBiome, BiomeManager.BiomeType.DESERT, "arid_highland", 4, TraverseConfig.disableAridHighland, false, DESERT_REPLACEMENTS, event, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS);
        TraverseWorld.register(V5, rockyPlainsBiome, BiomeManager.BiomeType.COOL, "rocky_plains", 4, TraverseConfig.disableRockyPlains, true, NO_REPLACEMENTS, event, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SPARSE);
    }

    public static void register(Version versionAdded, Biome biome, BiomeManager.BiomeType type, String name, int weight, boolean disabled, boolean canSpawn, VillageReplacements villageReplacements, RegistryEvent.Register<Biome> event, BiomeDictionary.Type ... biomeDictTypes) {
        if (!disabled) {
            biome.setRegistryName(new ResourceLocation("traverse", name));
            event.getRegistry().register((IForgeRegistryEntry)biome);
            for (BiomeDictionary.Type biomeDictType : biomeDictTypes) {
                BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{biomeDictType});
            }
            biomeList.add(new TraverseBiomeEntry(biome, type, weight, canSpawn, !TraverseConfig.disallowVillages && villageReplacements != NO_VILLAGES, versionAdded));
            if (!TraverseConfig.disallowVillages && villageReplacements != NO_VILLAGES && villageReplacements != NO_REPLACEMENTS) {
                villageReplacementBiomes.put(biome, villageReplacements);
            }
        }
    }

    public static void register(Version versionAdded, Biome biome, BiomeManager.BiomeType type, String name, int weight, boolean disabled, boolean canSpawn, RegistryEvent.Register<Biome> event, BiomeDictionary.Type ... biomeDictTypes) {
        TraverseWorld.register(versionAdded, biome, type, name, weight, disabled, canSpawn, NO_VILLAGES, event, biomeDictTypes);
    }

    @SubscribeEvent
    public static void replaceVillageBlocks(BiomeEvent.GetVillageBlockID event) {
        if (villageReplacementBiomes.keySet().contains(event.getBiome())) {
            event.setReplacement(villageReplacementBiomes.get(event.getBiome()).getBiomeSpecificState(event.getOriginal()));
            event.setResult(Event.Result.DENY);
        }
    }

    public static class TraverseBiomeEntry {
        private Biome biome;
        private BiomeManager.BiomeType type;
        private Version versionAdded;
        private int weight;
        private boolean canSpawn;
        private boolean hasVillages;
        private BiomeManager.BiomeEntry entry;

        public TraverseBiomeEntry(Biome biome, BiomeManager.BiomeType type, int weight, boolean canSpawn, boolean hasVillages, Version versionAdded) {
            this.biome = biome;
            this.type = type;
            this.weight = weight;
            this.canSpawn = canSpawn;
            this.hasVillages = hasVillages;
            this.versionAdded = versionAdded;
            this.entry = new BiomeManager.BiomeEntry(biome, weight);
        }

        public Biome getBiome() {
            return this.biome;
        }

        public BiomeManager.BiomeEntry getEntry() {
            return this.entry;
        }

        public BiomeManager.BiomeType getType() {
            return this.type;
        }

        public Version getVersionAdded() {
            return this.versionAdded;
        }

        public int getWeight() {
            return this.weight;
        }

        public boolean hasVillages() {
            return this.hasVillages;
        }

        public boolean canSpawn() {
            return this.canSpawn;
        }
    }

    public static interface VillageReplacements {
        public IBlockState getBiomeSpecificState(IBlockState var1);
    }
}

