/*
 * Decompiled with CFR 0.152.
 */
package lumberwizard.anvilpatch;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.Loader;

@Config(modid="anvilpatch")
public class ModConfig {
    @Config.Ignore
    private static boolean valuesOverridden = false;
    @Config.Comment(value={"Set to -1 to remove the cap.", "This setting will be ignored if Apotheosis is installed."})
    @Config.Name(value="New level cap")
    @Config.RangeInt(min=-1)
    public static int levelCap;
    @Config.Ignore
    private static int syncedLevelCap;
    @Config.Comment(value={"Valid values:", "KEEP - keeps the cumulative repair cost, same as vanilla.", "REMOVE_REPAIR_SCALING - repairs won't increase the xp cost, but enchantments will, even for repaired items.", "ENCHANTMENT_ONLY - repairs will always cost the same, but applying more enchantments will cost more.", "REMOVE - removes the cumulative repair cost entirely."})
    @Config.Name(value="XP cost increase")
    public static EnumCostIncreaseSetting costIncreaseSetting;
    @Config.Ignore
    private static EnumCostIncreaseSetting syncedCostIncreaseSetting;
    @Config.Comment(value={"Vanilla behavior, when merging two items where the one on the right has an enchantment with a level beyond its max", "(for example power 8) is to reset the level to the max (so the resulting item would have power 5)", "This setting disables that.", "It does not, however, allow creating enchantments beyond the cap", "So, for example, merging two power V books would still result in power V"})
    @Config.Name(value="Allow repairs beyond enchantment level cap.")
    public static boolean breakEnchantLevelCap;
    @Config.Ignore
    private static boolean syncedBreakEnchantLevelCap;
    @Config.Comment(value={"Chance for the anvil to reach the next stage of breakage per use.", "Choose a value from 0 to 1. Vanilla default is 0.12 (= 12%)."})
    @Config.Name(value="Anvil break chance")
    @Config.RangeDouble(min=0.0, max=1.0)
    public static float breakChance;
    @Config.Ignore
    private static float syncedBreakChance;

    public static void setSyncedValues(int levelCap, EnumCostIncreaseSetting costIncreaseSetting, boolean breakEnchantLevelCap, float breakChance) {
        syncedLevelCap = levelCap;
        syncedCostIncreaseSetting = costIncreaseSetting;
        syncedBreakEnchantLevelCap = breakEnchantLevelCap;
        syncedBreakChance = breakChance;
    }

    public static int getLevelCap() {
        if (Loader.isModLoaded((String)"apotheosis")) {
            return -1;
        }
        if (ModConfig.areValuesOverridden()) {
            return syncedLevelCap;
        }
        return levelCap;
    }

    public static EnumCostIncreaseSetting getCostIncreaseSetting() {
        if (ModConfig.areValuesOverridden()) {
            return syncedCostIncreaseSetting;
        }
        return costIncreaseSetting;
    }

    public static boolean shouldBreakEnchantLevelCap() {
        if (ModConfig.areValuesOverridden()) {
            return syncedBreakEnchantLevelCap;
        }
        return breakEnchantLevelCap;
    }

    public static float getBreakChance() {
        if (ModConfig.areValuesOverridden()) {
            return syncedBreakChance;
        }
        return breakChance;
    }

    public static boolean areValuesOverridden() {
        return valuesOverridden;
    }

    public static void setValuesOverridden(boolean valuesOverridden) {
        ModConfig.valuesOverridden = valuesOverridden;
    }

    static {
        syncedLevelCap = levelCap = -1;
        costIncreaseSetting = EnumCostIncreaseSetting.REMOVE_REPAIR_SCALING;
        breakEnchantLevelCap = false;
        syncedBreakChance = breakChance = 0.12f;
    }

    public static enum EnumCostIncreaseSetting {
        KEEP,
        REMOVE_REPAIR_SCALING,
        ENCHANTMENT_ONLY,
        REMOVE;

    }
}

