/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.particleculling;

import bl4ckscor3.mod.particleculling.CameraHolder;
import bl4ckscor3.mod.particleculling.ParticleCulling;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="particleculling", value={Side.CLIENT})
public class CullHook {
    public static boolean shouldRenderParticle(Particle particle, BufferBuilder buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (!ParticleCulling.Configuration.cullingEnabled) {
            return true;
        }
        if (!ParticleCulling.Configuration.cullInSpectator && Minecraft.func_71410_x().field_71439_g.func_175149_v()) {
            return true;
        }
        if (ParticleCulling.Configuration.ignoredParticleClasses.stream().anyMatch(clazz -> clazz.isAssignableFrom(particle.getClass()))) {
            return true;
        }
        ICamera camera = ((CameraHolder)Minecraft.func_71410_x().field_71438_f).getCamera();
        if (camera == null) {
            return true;
        }
        if (camera.func_78546_a(particle.func_187116_l())) {
            if (ParticleCulling.Configuration.cullBehindBlocks) {
                if (ParticleCulling.Configuration.blockBuffer == 1) {
                    RayTraceResult result = entity.field_70170_p.func_147447_a(new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), new Vec3d(particle.field_187126_f, particle.field_187127_g, particle.field_187128_h), false, true, true);
                    if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                        if (ParticleCulling.Configuration.cullBehindGlass) {
                            return false;
                        }
                        IBlockState state = entity.field_70170_p.func_180495_p(result.func_178782_a());
                        if (state.func_185917_h() && state.func_185914_p()) {
                            return false;
                        }
                    }
                } else if (CullHook.shouldCull(entity.field_70170_p, new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), new Vec3d(particle.field_187126_f, particle.field_187127_g, particle.field_187128_h))) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean shouldCull(World world, Vec3d from, Vec3d to) {
        if (!(Double.isNaN(from.field_72450_a) || Double.isNaN(from.field_72448_b) || Double.isNaN(from.field_72449_c) || Double.isNaN(to.field_72450_a) || Double.isNaN(to.field_72448_b) || Double.isNaN(to.field_72449_c))) {
            boolean opacityCheck = false;
            int blocks = 0;
            int toX = MathHelper.func_76128_c((double)to.field_72450_a);
            int toY = MathHelper.func_76128_c((double)to.field_72448_b);
            int toZ = MathHelper.func_76128_c((double)to.field_72449_c);
            int checkX = MathHelper.func_76128_c((double)from.field_72450_a);
            int checkY = MathHelper.func_76128_c((double)from.field_72448_b);
            int checkZ = MathHelper.func_76128_c((double)from.field_72449_c);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(checkX, checkY, checkZ);
            IBlockState state = world.func_180495_p((BlockPos)pos);
            Block block = state.func_177230_c();
            if (state.func_185890_d((IBlockAccess)world, (BlockPos)pos) != Block.field_185506_k && block.func_176209_a(state, false) && state.func_185910_a(world, (BlockPos)pos, from, to) != null) {
                ++blocks;
                opacityCheck = opacityCheck || ParticleCulling.Configuration.cullBehindGlass || state.func_185917_h() && state.func_185914_p();
            }
            int maxIterations = 50;
            while (maxIterations-- >= 0) {
                EnumFacing facing;
                if (checkX == toX && checkY == toY && checkZ == toZ) {
                    return opacityCheck && ++blocks > ParticleCulling.Configuration.blockBuffer;
                }
                boolean wasXChanged = true;
                boolean wasYChanged = true;
                boolean wasZChanged = true;
                double d0 = 999.0;
                double d1 = 999.0;
                double d2 = 999.0;
                if (toX > checkX) {
                    d0 = (double)checkX + 1.0;
                } else if (toX < checkX) {
                    d0 = (double)checkX + 0.0;
                } else {
                    wasXChanged = false;
                }
                if (toY > checkY) {
                    d1 = (double)checkY + 1.0;
                } else if (toY < checkY) {
                    d1 = (double)checkY + 0.0;
                } else {
                    wasYChanged = false;
                }
                if (toZ > checkZ) {
                    d2 = (double)checkZ + 1.0;
                } else if (toZ < checkZ) {
                    d2 = (double)checkZ + 0.0;
                } else {
                    wasZChanged = false;
                }
                double d3 = 999.0;
                double d4 = 999.0;
                double d5 = 999.0;
                double d6 = to.field_72450_a - from.field_72450_a;
                double d7 = to.field_72448_b - from.field_72448_b;
                double d8 = to.field_72449_c - from.field_72449_c;
                if (wasXChanged) {
                    d3 = (d0 - from.field_72450_a) / d6;
                }
                if (wasYChanged) {
                    d4 = (d1 - from.field_72448_b) / d7;
                }
                if (wasZChanged) {
                    d5 = (d2 - from.field_72449_c) / d8;
                }
                if (d3 == -0.0) {
                    d3 = -1.0E-4;
                }
                if (d4 == -0.0) {
                    d4 = -1.0E-4;
                }
                if (d5 == -0.0) {
                    d5 = -1.0E-4;
                }
                if (d3 < d4 && d3 < d5) {
                    facing = toX > checkX ? EnumFacing.WEST : EnumFacing.EAST;
                    from.field_72450_a = d0;
                    from.field_72448_b += d7 * d3;
                    from.field_72449_c += d8 * d3;
                } else if (d4 < d5) {
                    facing = toY > checkY ? EnumFacing.DOWN : EnumFacing.UP;
                    from.field_72450_a += d6 * d4;
                    from.field_72448_b = d1;
                    from.field_72449_c += d8 * d4;
                } else {
                    facing = toZ > checkZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    from.field_72450_a += d6 * d5;
                    from.field_72448_b += d7 * d5;
                    from.field_72449_c = d2;
                }
                checkX = MathHelper.func_76128_c((double)from.field_72450_a) - (facing == EnumFacing.EAST ? 1 : 0);
                checkY = MathHelper.func_76128_c((double)from.field_72448_b) - (facing == EnumFacing.UP ? 1 : 0);
                checkZ = MathHelper.func_76128_c((double)from.field_72449_c) - (facing == EnumFacing.SOUTH ? 1 : 0);
                pos.func_181079_c(checkX, checkY, checkZ);
                state = world.func_180495_p((BlockPos)pos);
                block = state.func_177230_c();
                if (state.func_185904_a() != Material.field_151567_E && (state.func_185890_d((IBlockAccess)world, (BlockPos)pos) == Block.field_185506_k || !block.func_176209_a(state, false) || state.func_185910_a(world, (BlockPos)pos, from, to) == null)) continue;
                boolean bl = opacityCheck = opacityCheck || ParticleCulling.Configuration.cullBehindGlass || state.func_185917_h() && state.func_185914_p();
                if (++blocks <= ParticleCulling.Configuration.blockBuffer) continue;
                return opacityCheck;
            }
            return opacityCheck && blocks > ParticleCulling.Configuration.blockBuffer;
        }
        return false;
    }
}

