/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.particleculling;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="particleculling", name="Particle Culling", version="v1.3", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(modid="particleculling")
public class ParticleCulling {
    public static final String MODID = "particleculling";
    public static final Logger LOGGER = LogManager.getLogger((String)"particleculling");
    public static Class<?> particleClass = null;

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        ParticleCulling.updateIgnoredParticles();
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
            ParticleCulling.updateIgnoredParticles();
        }
    }

    private static void updateIgnoredParticles() {
        Configuration.ignoredParticleClasses = new ArrayList();
        for (String className : Configuration.ignoredParticles) {
            try {
                Class<?> clazz = Class.forName(className);
                if (particleClass.isAssignableFrom(clazz)) {
                    Configuration.ignoredParticleClasses.add(clazz);
                    continue;
                }
                LOGGER.warn(className + " is not a particle class or does not extend the vanilla particle class!");
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Could not find particle class " + className + ". If the mod is not installed, this can be ignored.");
            }
        }
    }

    static {
        try {
            particleClass = Class.forName("net.minecraft.client.particle.Particle");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Could not find vanilla particle class! Something is wrong.");
        }
    }

    @Config(modid="particleculling")
    public static class Configuration {
        @Config.Comment(value={"Set this to false if you do not want to cull particles that technically are in the player's view but are obstructed by blocks."})
        public static boolean cullBehindBlocks = true;
        @Config.Comment(value={"Set this to true if you don't want particles to be rendered behind glass and other transparent blocks. This does nothing if \"cullBehindBlocks\" is turned off."})
        public static boolean cullBehindGlass = false;
        @Config.Comment(value={"Set this to false to disable particle culling while being in spectator mode. This is useful to take screenshots without having particles removed."})
        public static boolean cullInSpectator = true;
        @Config.Comment(value={"The minimum amount of blocks behind which particles start to get culled. Only effective if \"cullBehindBlocks\" is turned on."})
        @Config.RangeInt(min=1, max=50)
        public static int blockBuffer = 1;
        @Config.Comment(value={"Set this to false to disable all of particle culling's features."})
        public static boolean cullingEnabled = true;
        @Config.Comment(value={"Add particle classes here that should be ignored by Particle Culling.", "Example: To ignore Minecraft's breaking particles and any derivates, add \"net.minecraft.client.particle.ParticleBreaking\" to the list"})
        public static String[] ignoredParticles = new String[]{"org.orecruncher.dsurround.client.fx.particle.mote.ParticleCollection", "com.TominoCZ.FBP.particle.FBPParticleBlock", "xzeroair.trinkets.client.particles.ParticleGreed"};
        @Config.Ignore
        public static List<Class<?>> ignoredParticleClasses;
    }
}

