/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.api.util;

import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;

public class CreatureFoodStats {
    private int foodLevel = 20;
    private float foodSaturationLevel = 5.0f;
    private float foodExhaustionLevel;
    private int foodTimer;
    private final float minimumHealth;
    private final boolean damageEntity;

    public CreatureFoodStats() {
        this(false);
    }

    public CreatureFoodStats(boolean damageEntity) {
        this(0.0f, damageEntity);
    }

    public CreatureFoodStats(float minimumHealth, boolean damageEntity) {
        this.minimumHealth = Math.max(minimumHealth, 0.0f);
        this.damageEntity = damageEntity;
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public boolean needFood() {
        return this.foodLevel < 20;
    }

    public float getSaturationLevel() {
        return this.foodSaturationLevel;
    }

    public void setFoodLevel(int foodLevel) {
        this.foodLevel = foodLevel;
    }

    public void setSaturationLevel(float foodSaturationLevel) {
        this.foodSaturationLevel = foodSaturationLevel;
    }

    public void addStats(int level, float saturation) {
        this.foodLevel = Math.min(level + this.foodLevel, 20);
        this.foodSaturationLevel = Math.min(this.foodSaturationLevel + (float)level * saturation * 2.0f, (float)this.foodLevel);
    }

    public void addStats(@Nonnull ItemFood food, ItemStack stack) {
        this.addStats(food.func_150905_g(stack), food.func_150906_h(stack));
    }

    public void addExhaustion(float exhaustion) {
        this.foodExhaustionLevel = Math.min(this.foodExhaustionLevel + exhaustion, 40.0f);
    }

    public void onUpdate(EntityLivingBase entityLiving) {
        boolean canHeal;
        if (this.foodExhaustionLevel > 4.0f) {
            this.foodExhaustionLevel -= 4.0f;
            if (this.foodSaturationLevel > 0.0f) {
                this.foodSaturationLevel = Math.max(this.foodSaturationLevel - 1.0f, 0.0f);
            } else {
                this.foodLevel = Math.max(this.foodLevel - 1, 0);
            }
        }
        boolean naturalRegeneration = entityLiving.func_130014_f_().func_82736_K().func_82766_b("naturalRegeneration");
        boolean bl = canHeal = entityLiving.func_110143_aJ() > 0.0f && entityLiving.func_110143_aJ() < entityLiving.func_110138_aP();
        if (naturalRegeneration && canHeal && this.foodSaturationLevel > 0.0f && this.foodLevel >= 20) {
            ++this.foodTimer;
            if (this.foodTimer >= 10) {
                float saturation = Math.min(this.foodSaturationLevel, 6.0f);
                entityLiving.func_70691_i(saturation / 6.0f);
                this.addExhaustion(saturation);
                this.foodTimer = 0;
            }
        } else if (naturalRegeneration && canHeal && this.foodLevel >= 18) {
            ++this.foodTimer;
            if (this.foodTimer >= 80) {
                entityLiving.func_70691_i(1.0f);
                this.addExhaustion(6.0f);
                this.foodTimer = 0;
            }
        } else if (this.foodLevel <= 0) {
            ++this.foodTimer;
            if (this.foodTimer > 80) {
                if (this.damageEntity && entityLiving.func_110143_aJ() > this.minimumHealth) {
                    entityLiving.func_70097_a(DamageSource.field_76366_f, 1.0f);
                }
                this.foodTimer = 0;
            }
        } else {
            this.foodTimer = 0;
        }
    }

    public void readNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_150297_b("foodLevel", 99)) {
            this.foodLevel = nbtTagCompound.func_74762_e("foodLevel");
            this.foodTimer = nbtTagCompound.func_74762_e("foodTickTimer");
            this.foodSaturationLevel = nbtTagCompound.func_74760_g("foodSaturationLevel");
            this.foodExhaustionLevel = nbtTagCompound.func_74760_g("foodExhaustionLevel");
        }
    }

    public void writeNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("foodLevel", this.foodLevel);
        nbtTagCompound.func_74768_a("foodTickTimer", this.foodTimer);
        nbtTagCompound.func_74776_a("foodSaturationLevel", this.foodSaturationLevel);
        nbtTagCompound.func_74776_a("foodExhaustionLevel", this.foodExhaustionLevel);
    }
}

