/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.client.renderer.entity.layer;

import com.google.common.collect.Maps;
import dev.satyrn.wolfarmor.WolfArmorMod;
import dev.satyrn.wolfarmor.api.entity.passive.IArmoredWolf;
import dev.satyrn.wolfarmor.client.model.ModelWolfBackpack;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerWolfBackpack
implements LayerRenderer<EntityWolf> {
    protected ModelBase modelWolfBackpack;
    private final RenderLiving<?> renderer;
    private static final Map<String, ResourceLocation> WOLF_PACK_TEXTURE_MAP = Maps.newHashMap();

    public LayerWolfBackpack(@Nonnull RenderLiving<?> renderer) {
        this.renderer = renderer;
        this.modelWolfBackpack = new ModelWolfBackpack(0.0f);
    }

    public ModelBase getModelWolfBackpack() {
        return this.modelWolfBackpack;
    }

    public void doRenderLayer(@Nonnull EntityWolf entityWolf, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!WolfArmorMod.getConfig().getChestRendered()) {
            return;
        }
        IArmoredWolf wolfArmor = (IArmoredWolf)entityWolf;
        if (wolfArmor.getHasChest()) {
            this.modelWolfBackpack.func_178686_a(this.renderer.func_177087_b());
            this.modelWolfBackpack.func_78086_a((EntityLivingBase)entityWolf, limbSwing, limbSwingAmount, partialTicks);
            this.renderer.func_110776_a(this.getPackTextureForItem(wolfArmor.getChestType()));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!entityWolf.func_82150_aj()) {
                this.modelWolfBackpack.func_78088_a((Entity)entityWolf, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            } else {
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.modelWolfBackpack.func_78088_a((Entity)entityWolf, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
    }

    @Nonnull
    protected ResourceLocation getPackTextureForItem(@Nullable Item chestItem) {
        String path;
        ResourceLocation resource;
        ItemBlock block;
        String chestType = null;
        if (chestItem instanceof ItemBlock && (block = (ItemBlock)chestItem).func_179223_d().equals(Blocks.field_150477_bB)) {
            chestType = "ender";
        }
        if ((resource = WOLF_PACK_TEXTURE_MAP.get(path = String.format("%s:textures/entity/wolf/chest/%schest.png", "wolfarmor", chestType == null ? "" : chestType + "_"))) == null) {
            resource = new ResourceLocation(path);
            WOLF_PACK_TEXTURE_MAP.put(path, resource);
        }
        return resource;
    }

    public boolean func_177142_b() {
        return false;
    }
}

