/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.nbt.tags;

import jaredbgreat.dldungeons.nbt.NBTType;
import jaredbgreat.dldungeons.nbt.tags.ITag;
import jaredbgreat.dldungeons.nbt.tags.Tags;
import jaredbgreat.dldungeons.util.parser.Tokenizer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTList
extends ITag {
    private final List<ITag> data = new ArrayList<ITag>();
    private final int type;

    NBTList(String label, String name, String data) {
        super(label, name);
        this.parseData(data);
        this.type = this.data.get(0).getType().ordinal();
    }

    @Override
    public void write(NBTTagCompound in) {
        if (!in.func_150297_b(this.name, this.type)) {
            in.func_74782_a(this.name, (NBTBase)new NBTTagList());
        }
        for (ITag child : this.data) {
            NBTTagList list = in.func_150295_c(this.name, child.getType().ordinal());
            child.write(list);
        }
    }

    private void writeHelper(NBTTagCompound in, ITag child) {
    }

    @Override
    public void write(NBTTagList in) {
        for (ITag child : this.data) {
            child.write(in);
        }
    }

    private void parseData(String in) {
        Tokenizer tokens = new Tokenizer(in, ",");
        while (tokens.hasMoreTokens()) {
            this.data.add(Tags.registry.get(tokens.nextToken()));
        }
    }

    @Override
    public NBTType getType() {
        return NBTType.LIST;
    }
}

