/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import slimeknights.mantle.network.AbstractPacketThreadsafe;

public class MilkablePacket
extends AbstractPacketThreadsafe {
    private int entityID;
    private boolean milkable;

    public MilkablePacket() {
    }

    public MilkablePacket(Entity entity, boolean milkable) {
        this.entityID = entity.func_145782_y();
        this.milkable = milkable;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.milkable);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.milkable = buf.readBoolean();
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
        if (entity == null) {
            return;
        }
        NBTTagCompound tags = entity.getEntityData();
        tags.func_74777_a("milk_cooldown", (short)(this.milkable ? 0 : 100));
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        throw new UnsupportedOperationException("Clientside only");
    }
}

