/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionType;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IRegistryDelegate;

public final class ReflectionUtil {
    private static final Map<String, Field> FIELDS = new HashMap<String, Field>();
    private static final Map<String, Method> METHODS = new HashMap<String, Method>();
    private static final Map<String, Class<?>> CLASS = new HashMap();

    private ReflectionUtil() {
    }

    @Nullable
    public static PotionType getMixPredicateInput(@Nonnull Object mixPredicate) {
        Object val = ReflectionUtil.getFieldValue(ReflectionUtil.getClass("net.minecraft.potion.PotionHelper$MixPredicate"), mixPredicate, "input", "field_185198_a");
        if (val instanceof IRegistryDelegate) {
            return (PotionType)((IRegistryDelegate)val).get();
        }
        return (PotionType)val;
    }

    @Nullable
    public static Ingredient getMixPredicateReagent(@Nonnull Object mixPredicate) {
        return (Ingredient)ReflectionUtil.getFieldValue(ReflectionUtil.getClass("net.minecraft.potion.PotionHelper$MixPredicate"), mixPredicate, "reagent", "field_185199_b");
    }

    @Nullable
    public static PotionType getMixPredicateOutput(@Nonnull Object mixPredicate) {
        Object val = ReflectionUtil.getFieldValue(ReflectionUtil.getClass("net.minecraft.potion.PotionHelper$MixPredicate"), mixPredicate, "output", "field_185200_c");
        if (val instanceof IRegistryDelegate) {
            return (PotionType)((IRegistryDelegate)val).get();
        }
        return (PotionType)val;
    }

    @Nullable
    public static ItemStack invokeGetSilkTouchDrop(@Nonnull Block block, IBlockState state) {
        return (ItemStack)ReflectionUtil.invokeMethod(Block.class, block, "getSilkTouchDrop", "func_180643_i", new Class[]{IBlockState.class}, state);
    }

    public static Class<?> getClass(String className) {
        try {
            return CLASS.computeIfAbsent(className, key -> ReflectionHelper.getClass((ClassLoader)InspirationsRegistry.class.getClassLoader(), (String[])new String[]{key}));
        }
        catch (ReflectionHelper.UnableToFindClassException e) {
            InspirationsRegistry.log.error((Object)e);
            CLASS.putIfAbsent(className, null);
            return null;
        }
    }

    @Nullable
    private static <T> T invokeMethod(Class<?> classToSearch, Object instance, String mcpName, String srgName, Class<?>[] paramTypes, Object ... params) {
        try {
            Method m = METHODS.computeIfAbsent(srgName, key -> ReflectionHelper.findMethod((Class)classToSearch, (String)mcpName, (String)key, (Class[])paramTypes));
            return (T)m.invoke(instance, params);
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException | ReflectionHelper.UnableToFindMethodException e) {
            InspirationsRegistry.log.error((Object)e);
            METHODS.putIfAbsent(srgName, null);
            return null;
        }
    }

    @Nullable
    private static <T> T getFieldValue(Class<?> classToSearch, Object instance, String mcpName, String srgName) {
        try {
            Field f = FIELDS.computeIfAbsent(srgName, key -> ReflectionHelper.findField((Class)classToSearch, (String[])new String[]{key, mcpName}));
            return (T)(f != null ? f.get(instance) : null);
        }
        catch (ClassCastException | IllegalAccessException | NullPointerException | ReflectionHelper.UnableToFindFieldException e) {
            InspirationsRegistry.log.error((Object)e);
            FIELDS.putIfAbsent(srgName, null);
            return null;
        }
    }
}

