/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins;

import com.google.common.eventbus.Subscribe;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.recipes.recipe.ArmorClearRecipe;
import knightminer.inspirations.recipes.recipe.ArmorDyeingCauldronRecipe;
import net.minecraft.item.ItemArmor;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="TwilightForestPlugin", description="Supports dyeing Twilight Forest armor in the Inspirations cauldron.", modsRequired="twilightforest", pulsesRequired="InspirationsRecipes")
public class TwilightForestPlugin {
    public static final String pulseID = "TwilightForestPlugin";
    public static final String requiredModID = "twilightforest";

    @Subscribe
    public void init(FMLInitializationEvent event) {
        if (!Config.enableCauldronRecipes) {
            return;
        }
        try {
            ItemArmor.ArmorMaterial material = ItemArmor.ArmorMaterial.valueOf((String)"ARCTIC");
            InspirationsRegistry.addCauldronRecipe(new ArmorClearRecipe(material));
            if (Config.enableCauldronDyeing) {
                InspirationsRegistry.addCauldronRecipe(new ArmorDyeingCauldronRecipe(material));
            }
        }
        catch (IllegalArgumentException e) {
            Inspirations.log.error("Skipping registering Twilight Forest plugin, cannot find arctic armor material");
        }
    }
}

