/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei.cauldron;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import knightminer.inspirations.plugins.jei.cauldron.ICauldronRecipeWrapper;
import knightminer.inspirations.plugins.jei.cauldron.ingredient.PotionIngredient;
import knightminer.inspirations.plugins.jei.cauldron.ingredient.PotionIngredientHelper;
import knightminer.inspirations.recipes.block.BlockEnhancedCauldron;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.oredict.OreDictionary;

public abstract class PotionWrapper
implements ICauldronRecipeWrapper {
    protected static List<List<PotionIngredient>> potions = ImmutableList.of(PotionIngredientHelper.ALL_POTIONS);
    protected List<List<ItemStack>> filled;
    private ItemStack item;

    public PotionWrapper(ItemStack item) {
        this.item = item;
        this.filled = ImmutableList.of(PotionIngredientHelper.ALL_POTIONS.stream().map(potion -> PotionUtils.func_185188_a((ItemStack)item.func_77946_l(), (PotionType)potion.getPotion())).collect(Collectors.toList()));
    }

    @Override
    public ItemStack getPotionItem() {
        return this.item.func_77946_l();
    }

    @Override
    public BlockEnhancedCauldron.CauldronContents getInputType() {
        return BlockEnhancedCauldron.CauldronContents.POTION;
    }

    @Override
    public BlockEnhancedCauldron.CauldronContents getOutputType() {
        return BlockEnhancedCauldron.CauldronContents.POTION;
    }

    public static class Empty
    extends PotionWrapper {
        private ItemStack bottle;

        public Empty(ItemStack item, ItemStack bottle) {
            super(item);
            this.bottle = bottle;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setOutput(ItemStack.class, (Object)this.bottle);
            ingredients.setInputLists(ItemStack.class, this.filled);
            ingredients.setOutputLists(PotionIngredient.class, potions);
        }

        @Override
        public int getInputLevel() {
            return 0;
        }

        @Override
        public int getOutputLevel() {
            return 1;
        }
    }

    public static class Fill
    extends PotionWrapper {
        private List<List<ItemStack>> bottles;

        public Fill(ItemStack item, String bottle) {
            super(item);
            this.bottles = ImmutableList.of((Object)OreDictionary.getOres((String)bottle, (boolean)false));
        }

        public Fill(ItemStack item, ItemStack bottle) {
            super(item);
            this.bottles = ImmutableList.of((Object)ImmutableList.of((Object)bottle));
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(ItemStack.class, this.bottles);
            ingredients.setOutputLists(ItemStack.class, this.filled);
            ingredients.setInputLists(PotionIngredient.class, potions);
        }

        @Override
        public int getInputLevel() {
            return 1;
        }

        @Override
        public int getOutputLevel() {
            return 1;
        }
    }
}

